/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;

public class ComponentUtilities {
    private static final String ENABLED_VETOS_KEY = "enabledVetos";

    public static void addEnabledVeto(JComponent comp, Object veto) {
        HashSet<Object> eb = (HashSet<Object>)comp.getClientProperty(ENABLED_VETOS_KEY);
        if (eb == null) {
            eb = new HashSet<Object>();
        }
        eb.add(veto);
        comp.putClientProperty(ENABLED_VETOS_KEY, eb);
    }

    public static boolean isEnabledVetoed(JComponent comp) {
        return comp.getClientProperty(ENABLED_VETOS_KEY) != null;
    }

    public static void removeEnabledVeto(JComponent comp, Object veto) {
        Set eb = (Set)comp.getClientProperty(ENABLED_VETOS_KEY);
        if (eb == null) {
            return;
        }
        eb.remove(veto);
        if (eb.isEmpty()) {
            eb = null;
        }
        comp.putClientProperty(ENABLED_VETOS_KEY, eb);
    }

    public static void whenSelectedEnable(AbstractButton button, JComponent ... comps) {
        ComponentUtilities.whenSelectedEnable(button, false, comps);
    }

    public static void whenSelectedDisable(AbstractButton button, JComponent ... comps) {
        ComponentUtilities.whenSelectedEnable(button, true, comps);
    }

    public static void whenSelectedEnable(AbstractButton button, JComponent comp) {
        ComponentUtilities.whenSelectedEnable(button, false, comp);
    }

    public static void whenSelectedDisable(AbstractButton button, JComponent comp) {
        ComponentUtilities.whenSelectedEnable(button, true, comp);
    }

    public static void whenEqualsEnable(JComboBox cbox, Object value, JComponent ... comps) {
        ComponentUtilities.whenEqualsEnable(cbox, value, false, comps);
    }

    public static void whenEqualsDisable(JComboBox cbox, Object value, JComponent ... comps) {
        ComponentUtilities.whenEqualsEnable(cbox, value, true, comps);
    }

    public static void whenEqualsEnable(JComboBox cbox, Object value, JComponent comp) {
        ComponentUtilities.whenEqualsEnable(cbox, value, false, comp);
    }

    public static void whenEqualsDisable(JComboBox cbox, Object value, JComponent comp) {
        ComponentUtilities.whenEqualsEnable(cbox, value, true, comp);
    }

    private static void whenEqualsEnable(JComboBox cbox, Object value, boolean invert, JComponent ... comps) {
        ItemListener il = e -> {
            for (JComponent comp : comps) {
                if (ComponentUtilities.isEnabledVetoed(comp)) continue;
                comp.setEnabled(value.equals(cbox.getSelectedItem()) ^ invert);
            }
        };
        cbox.addItemListener(il);
        il.itemStateChanged(null);
    }

    private static void whenSelectedEnable(AbstractButton button, boolean invert, JComponent ... comps) {
        ChangeListener cl = e -> {
            for (JComponent comp : comps) {
                if (ComponentUtilities.isEnabledVetoed(comp)) continue;
                comp.setEnabled(button.isSelected() ^ invert);
            }
        };
        button.addChangeListener(cl);
        cl.stateChanged(null);
    }
}

