/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.Optional;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import se.datadosen.component.DirectoryChooser;
import se.datadosen.component.FXFileChooser;
import se.datadosen.component.FileChooser;
import se.datadosen.component.JDirectoryChooser;
import se.datadosen.component.JSwingFileChooser;
import se.datadosen.component.MacAWTDirectoryChooser;
import se.datadosen.component.MacAWTFileChooser;
import se.datadosen.component.mac.MacFileChooser;
import se.datadosen.component.windows.WindowsFileChooser;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DeferredChooser;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.util.Platform;

public class ChooserFactory {
    public static DirectoryChooser createDirectoryChooser(Window parent) {
        if (Platform.isMac()) {
            return new MacAWTDirectoryChooser(parent);
        }
        if (Config.getConfig().isUseNativeFileDialogs() && FXFileChooser.FX_AVAILABLE) {
            return FXFileChooser.createDirectoryChooser();
        }
        return new DeferredChooser(JDirectoryChooser.class);
    }

    public static FileChooser createFileChooser(Window parent) {
        if (Platform.isMac()) {
            return new MacAWTFileChooser(parent);
        }
        if (Config.getConfig().isUseNativeFileDialogs() && FXFileChooser.FX_AVAILABLE) {
            return FXFileChooser.createFileChooser();
        }
        return new DeferredChooser(JFileChooser.class);
    }

    public static FileChooser createFilesChooser(Frame parent) {
        return ChooserFactory.createFilesChooser((Window)parent);
    }

    public static FileChooser createFilesChooser(Window parent) {
        if (Platform.isMac() && Config.getConfig().isUseNativeFileDialogs()) {
            try {
                MacFileChooser chooser = new MacFileChooser();
                chooser.setMultiSelectionEnabled(true);
                return chooser;
            }
            catch (Throwable t) {
                System.err.println(t);
            }
        }
        FileChooser chooser = Platform.isWindows() ? new WindowsFileChooser() : (Config.getConfig().isUseNativeFileDialogs() ? FXFileChooser.createFilesChooser() : new JSwingFileChooser());
        chooser.setMultiSelectionEnabled(true);
        return chooser;
    }

    public static Optional<File> getMyPicturesDirectory() {
        Preferences prefs = Preferences.userNodeForPackage(JAlbum.class);
        String initialPicturesPath = prefs.get("initialPicturesPath", null);
        File dir = null;
        if (initialPicturesPath != null) {
            dir = new File(initialPicturesPath);
        } else {
            String myPicturesPath = System.getProperty("my.pictures.path");
            if (myPicturesPath != null) {
                dir = new File(myPicturesPath);
            }
        }
        return Optional.ofNullable(dir);
    }
}

