/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import se.datadosen.component.FileChooser;

class AWTFileChooser
implements FileChooser {
    private FileDialog dialog;
    private ActionListener listener;

    public AWTFileChooser(Window parent) {
        if (parent instanceof Frame) {
            this.dialog = new FileDialog((Frame)parent);
        } else if (parent instanceof Dialog) {
            this.dialog = new FileDialog((Dialog)parent);
        } else {
            throw new IllegalArgumentException("Parent not instance of Frame or Dialog");
        }
    }

    @Override
    public void setCurrentDirectory(File dir) {
        if (dir != null) {
            this.dialog.setDirectory(dir.getAbsolutePath());
        }
    }

    @Override
    public File getCurrentDirectory() {
        return new File(this.dialog.getDirectory());
    }

    @Override
    public void setSelectedFile(File file) {
        if (file != null) {
            this.setCurrentDirectory(file.getParentFile());
            this.dialog.setFile(file.getName());
        } else {
            this.dialog.setFile(null);
        }
    }

    @Override
    public File getSelectedFile() {
        if (this.dialog.getFile() == null) {
            return null;
        }
        return new File(this.dialog.getDirectory(), this.dialog.getFile());
    }

    @Override
    public void setDialogTitle(String title) {
        this.dialog.setTitle(title);
    }

    private int showDialog(Component parent) {
        this.dialog.setVisible(true);
        if (this.dialog.getFile() != null && this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, 0, "ApproveSelection"));
        }
        return this.dialog.getFile() != null ? 0 : 1;
    }

    @Override
    public int showOpenDialog(Component parent) {
        this.dialog.setMode(0);
        return this.showDialog(parent);
    }

    @Override
    public int showSaveDialog(Component parent) {
        this.dialog.setMode(1);
        return this.showDialog(parent);
    }

    @Override
    public void setDialogType(int dialogType) {
        switch (dialogType) {
            case 0: {
                this.dialog.setMode(0);
                break;
            }
            case 1: {
                this.dialog.setMode(1);
                break;
            }
            case 2: {
                this.dialog.setMode(0);
            }
        }
    }

    @Override
    public void setMultiSelectionEnabled(boolean b) {
        try {
            FileDialog.class.getMethod("setMultipleMode", Boolean.TYPE).invoke((Object)this.dialog, b);
            throw new UnsupportedOperationException("Not supported yet.");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | UnsupportedOperationException | InvocationTargetException ex) {
            System.err.println(ex);
            return;
        }
    }

    @Override
    public void setFileSelectionMode(int mode) {
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listener = l;
    }

    @Override
    public void setFileView(FileView fileView) {
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        this.dialog.setFilenameFilter((dir, name) -> filter.accept(new File(dir, name)));
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        return this.showDialog(parent);
    }

    @Override
    public File[] getSelectedFiles() {
        try {
            return (File[])FileDialog.class.getMethod("getFiles", new Class[0]).invoke((Object)this.dialog, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            return new File[]{this.getSelectedFile()};
        }
    }
}

