/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.views;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.TreeCollection;
import se.datadosen.jalbum.ViewAlbumObject;

public class ViewSupport {
    private final AlbumObject viewFolder;
    private final AlbumObject viewRoot;

    public ViewSupport(AlbumObject viewFolder) {
        this.viewFolder = viewFolder;
        this.viewRoot = viewFolder.getViewRoot();
        if (this.viewRoot == null) {
            throw new IllegalArgumentException("Argument is not part of a View");
        }
    }

    public AlbumObject getViewRoot() {
        return this.viewRoot;
    }

    private String keyOf(AlbumObject ao) {
        return ao.getPathFrom(this.viewRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProperties() {
        AlbumObject albumObject = this.viewRoot;
        synchronized (albumObject) {
            Map folderImages = this.viewRoot.getProperties().computeIfAbsent("folderImages", k -> new HashMap());
            return (Map)folderImages.computeIfAbsent(this.keyOf(this.viewFolder), k -> new HashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() {
        if (this.viewRoot instanceof ViewAlbumObject && ((ViewAlbumObject)this.viewRoot).isBuilding()) {
            return;
        }
        AlbumObject albumObject = this.viewRoot;
        synchronized (albumObject) {
            Map folderImages = (Map)this.viewRoot.getProperties().get("folderImages");
            if (folderImages != null) {
                Set usedKeys = TreeCollection.of(this.viewRoot).filter(ao -> ao.isFolder()).stream().map(ao -> this.keyOf((AlbumObject)ao)).collect(Collectors.toSet());
                folderImages.keySet().removeIf(key -> !usedKeys.contains(key));
            }
            this.viewRoot.getProperties().save();
        }
    }
}

