/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import net.jalbum.views.AbstractView;
import net.miginfocom.swing.MigLayout;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.ViewAlbumObject;
import se.datadosen.jalbum.structure.JPlaceGroupsPanel;
import se.datadosen.jalbum.structure.PlaceTransformer;
import se.datadosen.util.Multilingual;

public class PlaceView
extends AbstractView<PlaceTransformer> {
    private static final ImageIcon icon = (ImageIcon)Icons.get("view by location", 192);
    private transient MultilingualTree tree;
    private transient JPlaceGroupsPanel groupsPanel;
    private transient JAlbumExplorer context;

    public PlaceView() {
        super(new PlaceTransformer());
    }

    @Override
    public JComponent getUserInterfaceComponent(ViewAlbumObject viewObject, JAlbumExplorer context) {
        this.context = context;
        this.tree = new MultilingualTree();
        this.groupsPanel = new JPlaceGroupsPanel(this.tree);
        JPanel ui = new JPanel((LayoutManager)new MigLayout("wrap", "[][grow]", "[][grow]"));
        ui.add((Component)this.groupsPanel, "span 1 2, grow");
        ui.add(new JLabel(Msg.get("ui.example")));
        JScrollPane scroller = new JScrollPane(this.tree);
        scroller.setMinimumSize(new Dimension(150, 200));
        ui.add((Component)scroller, "grow");
        this.groupsPanel.setPatternGroups(((PlaceTransformer)this.transformer).getPatternGroups());
        this.groupsPanel.addPropertyChangeListener("patternGroups", pce -> {
            ((PlaceTransformer)this.transformer).setPatternGroups(this.groupsPanel.getPatternGroups());
            if (this.onLeaveEdit != null) {
                this.onLeaveEdit.run();
            }
        });
        return ui;
    }

    @Override
    public String getName() {
        return Msg.get("view.place");
    }

    @Override
    public ImageIcon getIcon() {
        return icon;
    }

    private class MultilingualTree
    extends JTree
    implements Multilingual {
        private MultilingualTree() {
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        @Override
        public void languageUpdated() {
            PlaceView.this.groupsPanel.updateSample();
        }
    }
}

