/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import net.jalbum.views.AbstractView;
import net.miginfocom.swing.MigLayout;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.ViewAlbumObject;
import se.datadosen.jalbum.structure.CalendarTransformer;
import se.datadosen.jalbum.structure.JDateGroupsPanel;
import se.datadosen.util.Multilingual;

public class DateView
extends AbstractView<CalendarTransformer> {
    private static final ImageIcon icon = (ImageIcon)Icons.get("view by date", 192);
    private transient MultilingualTree tree;
    private transient JDateGroupsPanel groupsPanel;
    private transient JAlbumExplorer context;

    public DateView() {
        super(new CalendarTransformer());
    }

    @Override
    public JComponent getUserInterfaceComponent(ViewAlbumObject viewObject, JAlbumExplorer context) {
        this.context = context;
        this.tree = new MultilingualTree();
        this.groupsPanel = new JDateGroupsPanel(this.tree);
        JPanel ui = new JPanel((LayoutManager)new MigLayout("wrap", "[][grow]", "[][grow]"));
        ui.add((Component)this.groupsPanel, "span 1 2, grow");
        ui.add(new JLabel(Msg.get("ui.example")));
        JScrollPane scroller = new JScrollPane(this.tree);
        scroller.setMinimumSize(new Dimension(150, 200));
        ui.add((Component)scroller, "grow");
        this.groupsPanel.setPatternGroups(((CalendarTransformer)this.transformer).getPatternGroups());
        this.groupsPanel.addPropertyChangeListener("patternGroups", pce -> ((CalendarTransformer)this.transformer).setPatternGroups(this.groupsPanel.getPatternGroups()));
        return ui;
    }

    @Override
    public String getName() {
        return Msg.get("view.date");
    }

    @Override
    public ImageIcon getIcon() {
        return icon;
    }

    private class MultilingualTree
    extends JTree
    implements Multilingual {
        private MultilingualTree() {
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(200, 200);
        }

        @Override
        public void languageUpdated() {
            DateView.this.groupsPanel.updateSample();
        }
    }
}

