/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.views;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.concurrent.CompletableFuture;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.jalbum.undo.EditGroup;
import net.jalbum.undo.UndoableGroupEdit;
import net.jalbum.views.AbstractView;
import net.miginfocom.swing.MigLayout;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JSmartSyntaxTextArea;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.ScriptLanguage;
import se.datadosen.jalbum.ViewAlbumObject;
import se.datadosen.jalbum.structure.CustomFilterTransformer;
import se.datadosen.util.Debug;
import se.datadosen.util.NameValue;

public class CustomFilterView
extends AbstractView<CustomFilterTransformer> {
    private static final ImageIcon icon = (ImageIcon)Icons.get("view custom", 192);
    private transient JAlbumExplorer context;

    public CustomFilterView() {
        super(new CustomFilterTransformer());
    }

    @Override
    public JComponent getUserInterfaceComponent(ViewAlbumObject viewObject, JAlbumExplorer context) {
        this.context = context;
        return new UI();
    }

    @Override
    public String getName() {
        return Msg.get("view.customFilter");
    }

    @Override
    public ImageIcon getIcon() {
        return icon;
    }

    private class UI
    extends ControlPanel {
        JComboBox<NameValue<String>> samplesCombo = new JComboBox<Object>(new Object[]{new NameValue<String>(Msg.get("select"), ""), new NameValue<String>("All", "true"), new NameValue<String>("None", "false"), new NameValue<String>("Top rated", "obj.rating >= 4 // Top rated"), new NameValue<String>("Red flagged", "obj.flag == Flag.Select // Red flagged\n//obj.flag == Flag.NoFlag // Unflagged\n// obj.flag == Flag.Second // Yellow flagged\n// obj.flag == Flag.Review // Blue flagged\n// obj.flag == Flag.Approved // Green flagged"), new NameValue<String>("Videos", "obj.category == Category.video"), new NameValue<String>("Media", "obj.category == Category.video || obj.category == Category.audio"), new NameValue<String>("Tagged 'John'", "\"John\" in obj.keywordSet"), new NameValue<String>("Tagged 'John' and 'Sally'", "\"John\" in obj.keywordSet && \"Sally\" in obj.keywordSet"), new NameValue<String>("Tagged 'John' or 'Sally'", "\"John\" in obj.keywordSet || \"Sally\" in obj.keywordSet"), new NameValue<String>("Commented", "obj.comment.length() > 0"), new NameValue<String>("Portrait images", "obj.imageInfo?.height > obj.imageInfo?.width"), new NameValue<String>("Has audio clip", "obj.attachments.isPresent(Attachments.Type.AUDIO)"), new NameValue<String>("Nikon shots", "obj.vars.cameraMake?.toUpperCase()?.startsWith(\"NIKON\")"), new NameValue<String>("Macro lens", "obj.vars.focalLength == \"150mm\" // Macro lens"), new NameValue<String>("Summer time", "import java.time.*;\nLocalDate date = Instant.ofEpochMilli(obj.cameraDate)\n                .atZone(ZoneId.systemDefault())\n                .toLocalDate();\n\n        int month = date.getMonthValue();\n        return month >= 6 && month <= 8; // June (6) to August (8)")});
        JLabel expressionLabel = new JLabel(Msg.get("ui.groovyExpression") + ":");
        JSmartSyntaxTextArea console = new JSmartSyntaxTextArea();
        RTextScrollPane scroller = new RTextScrollPane((RTextArea)this.console, true);
        JLabel sizeLabel = new JLabel();
        JLinkLabel apiDocs = new JLinkLabel("https://jalbum.net/api/se/datadosen/jalbum/AlbumObject.html", Msg.get("ui.apiDocumentation"));
        Action checkSizeAction = new AbstractAction(Msg.get("ui.checkSize")){

            @Override
            public void actionPerformed(ActionEvent e) {
                UI.this.uiChanged();
                this.setEnabled(false);
                UI.this.sizeLabel.setText(Msg.get("ui.calculatingSize") + "...");
                UI.this.sizeLabel.setVisible(true);
                UndoableGroupEdit ge = new UndoableGroupEdit(Msg.get("ui.groovyExpression"));
                ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    try (EditGroup _v = new EditGroup(Msg.get("ui.groovyExpression"));){
                        Integer n = ((CustomFilterTransformer)CustomFilterView.this.transformer).transform(CustomFilterView.this.viewSource).getChildren().size();
                        return n;
                    }
                }).thenAcceptAsync(result -> JAlbumUtilities.runOnAWT(() -> {
                    this.setEnabled(true);
                    UI.this.sizeLabel.setText(Msg.get("ui.nMatchingObjects", result));
                }))).exceptionally(t -> {
                    UI.this.sizeLabel.setText("");
                    this.setEnabled(true);
                    Debug.showErrorDialog(UI.this, t.getCause());
                    return null;
                });
            }
        };

        public UI() {
            this.setLayout((LayoutManager)new MigLayout("wrap", "[grow]"));
            this.samplesCombo.addActionListener(ae -> this.console.setText((String)((NameValue)this.samplesCombo.getSelectedItem()).value));
            this.samplesCombo.setMaximumRowCount(20);
            this.console.setColumns(36);
            this.console.setRows(10);
            this.console.setSyntaxEditingStyle(ScriptLanguage.GROOVY.getMimeType());
            this.console.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    UI.this.uiChanged();
                }
            });
            this.add((Component)this.expressionLabel, "split 3, grow");
            this.add(new JLabel(Msg.get("ui.samples")));
            this.add(this.samplesCombo);
            this.add((Component)this.scroller, "grow");
            this.add((Component)new JButton(this.checkSizeAction), "split 3");
            this.add((Component)this.sizeLabel, "grow");
            this.add(this.apiDocs);
            this.console.setText(((CustomFilterTransformer)CustomFilterView.this.transformer).getFilterExpression());
            CustomFilterView.this.onLeaveEdit(() -> this.uiChanged());
        }

        private void uiChanged() {
            ((CustomFilterTransformer)CustomFilterView.this.transformer).setFilterExpression(this.console.getText());
        }
    }
}

