/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.util;

import com.drew.lang.annotations.NotNull;
import java.awt.Component;
import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.jalbum.undo.EditGroup;
import net.jalbum.util.BiOperation;
import net.jalbum.util.Counter;
import net.jalbum.util.MonitoredWorkQueue;
import net.jalbum.util.Operation;
import net.jalbum.util.WorkException;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.util.Debug;
import se.datadosen.util.Stopwatch;

public class Work<T> {
    @NotNull
    private Stream<T> data;
    private Counter processed = new Counter();
    private final MonitoredWorkQueue workQueue = new MonitoredWorkQueue(JAlbumContext.getInstance().getFrame(), "Untitled work");
    private Function<T, String> message = item -> item.toString();
    private int userChoice = 0;
    private Consumer<WorkException> errorHandler;
    private Predicate<T> filter;
    private Stopwatch stopwatch = new Stopwatch();

    private Work(Stream<T> data) {
        this.data = data;
    }

    public static <T> Work<T> on(Collection<T> data) {
        return Work.on(data.stream());
    }

    public static <T> Work<T> on(T[] data) {
        return Work.on(Arrays.stream(data));
    }

    public static <T> Work<T> on(Stream<T> data) {
        return new Work<T>(data);
    }

    public Work<T> titled(String title) {
        this.workQueue.title = title;
        return this;
    }

    public Work<T> owner(Component parentComponent) {
        this.workQueue.parentComponent = parentComponent;
        return this;
    }

    public Work<T> status(Function<T, String> messageSupplier) {
        this.message = messageSupplier;
        return this;
    }

    public Work<T> parallelism(int parallelism) {
        this.workQueue.setParallelism(parallelism);
        return this;
    }

    public boolean isCancelled() {
        return this.userChoice != 0 && this.userChoice != 0;
    }

    public Work<T> filter(Predicate<T> filter) {
        this.data = this.data.filter(filter);
        return this;
    }

    public Work<T> forEach(Operation<T> op) {
        return this.forEach((T item, Counter ctr) -> {
            op.accept(item);
            ctr.incrementAndGet();
        });
    }

    public Work<T> forEach(BiOperation<T, Counter> op) {
        if (this.isCancelled()) {
            return this;
        }
        this.workQueue.onError((Throwable _we) -> {
            WorkException we = (WorkException)_we;
            if (this.errorHandler != null) {
                this.errorHandler.accept(we);
            } else {
                SwingUtilities.invokeLater(() -> Debug.showErrorDialog(this.workQueue.parentComponent, we.getMessage(), we.getCause()));
            }
        });
        this.workQueue.submit(() -> {
            this.stopwatch.start();
            try (EditGroup _v = new EditGroup(this.workQueue.title);){
                this.data.forEach((? super T item) -> {
                    try {
                        this.workQueue.setMessage(this.message.apply(item));
                        if (this.workQueue.isAborted()) {
                            throw new OperationAbortedException();
                        }
                        op.accept(item, this.processed);
                    }
                    catch (OperationAbortedException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new WorkException("Error processing " + item.toString(), item, ex);
                    }
                });
            }
            catch (OperationAbortedException operationAbortedException) {
            }
            finally {
                this.stopwatch.stop();
            }
        });
        this.workQueue.awaitCompletion();
        return this;
    }

    public void onError(Consumer<WorkException> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Work execute(Consumer<Work> code) {
        code.accept(this);
        return this;
    }

    public Work onDialogOpening(Consumer<Dialog> onOpeningDialog) {
        this.workQueue.onDialogOpening(onOpeningDialog);
        return this;
    }

    public Work<T> inform(Object prompt) {
        this.userChoice = JOptionPane.showConfirmDialog(this.workQueue.parentComponent, prompt, this.workQueue.title, 2, 1);
        return this;
    }

    public Work<T> ask(Object question) {
        this.userChoice = JOptionPane.showConfirmDialog(this.workQueue.parentComponent, question, this.workQueue.title, 0, 3);
        return this;
    }

    public Work<T> showResult() {
        this.showResult(Msg.get("ui.workResultReport"));
        return this;
    }

    public Work<T> showResult(String template) {
        if (this.isCancelled()) {
            return this;
        }
        JOptionPane.showMessageDialog(this.workQueue.parentComponent, MessageFormat.format(template, this.processed, this.stopwatch), this.workQueue.title, 1);
        return this;
    }

    public Work<T> printResult() {
        this.printResult(Msg.get("ui.workResultReport"));
        return this;
    }

    public Work<T> printResult(String template) {
        if (this.isCancelled()) {
            return this;
        }
        System.out.println(MessageFormat.format(template, this.processed, this.stopwatch));
        return this;
    }

    public long getProcessed() {
        return this.processed.get();
    }

    public Stopwatch getTiming() {
        return this.stopwatch;
    }

    public boolean isAborted() {
        return this.workQueue != null ? this.workQueue.isAborted() : false;
    }

    public Work<T> millisToPopup(int millisToPopup) {
        this.workQueue.setMillisToPopup(millisToPopup);
        return this;
    }
}

