/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ReadOnlyProxy {
    public static <T> T createReadOnlyProxy(final T delegate, Class<T> iface) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException("Provided class must be an interface");
        }
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (this.isSetter(method)) {
                    throw new UnsupportedOperationException("Read-only proxy: cannot call " + method.getName());
                }
                return method.invoke(delegate, args);
            }

            private boolean isSetter(Method method) {
                return method.getName().startsWith("set") && method.getReturnType() == Void.TYPE && method.getParameterCount() == 1;
            }
        });
    }
}

