/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.util;

import io.nayuki.qrcodegen.QrCode;
import java.awt.image.BufferedImage;
import java.util.Objects;

public class QR {
    public static BufferedImage toImage(QrCode qr) {
        return QR.toImage(qr, 4, 10);
    }

    public static BufferedImage toImage(QrCode qr, int scale, int border) {
        return QR.toImage(qr, scale, border, 0xFFFFFF, 0);
    }

    public static BufferedImage toImage(QrCode qr, int scale, int border, int lightColor, int darkColor) {
        Objects.requireNonNull(qr);
        if (scale <= 0 || border < 0) {
            throw new IllegalArgumentException("Value out of range");
        }
        if (border > 0x3FFFFFFF || (long)qr.size + (long)border * 2L > (long)(Integer.MAX_VALUE / scale)) {
            throw new IllegalArgumentException("Scale or border too large");
        }
        BufferedImage result = new BufferedImage((qr.size + border * 2) * scale, (qr.size + border * 2) * scale, 1);
        for (int y = 0; y < result.getHeight(); ++y) {
            for (int x = 0; x < result.getWidth(); ++x) {
                boolean color = qr.getModule(x / scale - border, y / scale - border);
                result.setRGB(x, y, color ? darkColor : lightColor);
            }
        }
        return result;
    }
}

