/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import se.datadosen.util.Stopwatch;
import se.datadosen.util.StringUtil;

public final class Profiler {
    private static Profiler instance;
    private final Map<String, Sample> map = new HashMap<String, Sample>();
    private final Map<String, SampleSettings> settingsMap = new HashMap<String, SampleSettings>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample measure(String what) {
        Sample smp = this.map.get(what);
        if (smp == null) {
            Map<String, Sample> map = this.map;
            synchronized (map) {
                smp = this.map.get(what);
                if (smp == null) {
                    smp = new Sample(what);
                    SampleSettings settings = this.settingsMap.get(what);
                    if (settings != null && settings.traceCalls) {
                        smp.callStacks = new HashMap<String, AtomicInteger>();
                    }
                    this.map.put(what, smp);
                }
            }
        }
        smp.start();
        return smp;
    }

    public void reset() {
        this.map.clear();
    }

    public void resetSettings() {
        this.settingsMap.clear();
    }

    public Sample getSample(String what) {
        return this.map.get(what);
    }

    public SampleSettings forSample(String what) {
        SampleSettings ss = this.settingsMap.get(what);
        if (ss == null) {
            ss = new SampleSettings();
            this.settingsMap.put(what, ss);
        }
        return ss;
    }

    public static Profiler getInstance() {
        if (instance == null) {
            instance = new Profiler();
        }
        return instance;
    }

    public static Sample profile(String what) {
        return Profiler.getInstance().measure(what);
    }

    public static Sample profile() {
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        String className = caller.getClassName();
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex >= 0) {
            className = className.substring(dotIndex + 1);
        }
        return Profiler.getInstance().measure(className + "." + caller.getMethodName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        this.map.values().stream().sorted((a, b) -> (int)(b.time.getMillis() - a.time.getMillis())).forEach(m -> sb.append(m).append("\n"));
        Sample total = new Sample("Total");
        total.calls.set(this.map.values().stream().mapToInt(m -> m.calls.get()).sum());
        total.time.setMillis(this.map.values().stream().mapToLong(m -> m.time.getMillis()).sum());
        sb.append(total).append("\n");
        return sb.toString();
    }

    public static final class Sample
    implements AutoCloseable {
        private final String what;
        private final AtomicInteger calls = new AtomicInteger();
        private final Stopwatch time = new Stopwatch();
        private final AtomicInteger currentCalls = new AtomicInteger();
        private Map<String, AtomicInteger> callStacks;

        public Sample(String what) {
            this.what = what;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            if (this.currentCalls.incrementAndGet() == 1) {
                this.time.start();
            }
            this.calls.incrementAndGet();
            if (this.callStacks != null) {
                AtomicInteger counter;
                String cs = this.getCallStack();
                Sample sample = this;
                synchronized (sample) {
                    counter = this.callStacks.get(cs);
                    if (counter == null) {
                        counter = new AtomicInteger(0);
                    }
                }
                counter.incrementAndGet();
                this.callStacks.putIfAbsent(cs, counter);
            }
        }

        public void stop() {
            if (this.currentCalls.decrementAndGet() == 0) {
                this.time.stop();
            }
        }

        public String toString() {
            long lines = this.what.chars().filter(ch -> ch == 10).count();
            Object s = StringUtil.limit(this.what, 50);
            if (lines > 1L) {
                s = (String)s + " (" + (lines + 1L) + " lines)";
            }
            return String.format("%50s: %11s%12s", s, String.valueOf(this.calls) + " calls", this.time);
        }

        private String getCallStack() {
            String module;
            StackTraceElement e;
            int i;
            StackTraceElement[] elements = Thread.currentThread().getStackTrace();
            StringBuilder buf = new StringBuilder();
            for (i = 1; i < elements.length && (e = elements[i]).getClassName().startsWith(Profiler.class.getName()); ++i) {
                ++i;
            }
            while (i < elements.length && !"java.base".equals(module = (e = elements[i]).getModuleName()) && !"java.desktop".equals(module)) {
                buf.append(e.toString()).append("\n");
                ++i;
            }
            if (i < elements.length - 1) {
                buf.append("...\n");
            }
            return buf.toString();
        }

        public String getCallStacks() {
            if (this.callStacks == null) {
                return "Call tracing deactivated. Use Profiler.forSample(\"" + this.what + "\").setTraceCalls(true) to activate";
            }
            StringBuilder buf = new StringBuilder();
            buf.append("\nCall stacks for ").append(this.what).append(":\n");
            for (Map.Entry<String, AtomicInteger> e : this.callStacks.entrySet()) {
                buf.append(e.getValue()).append(" calls:\n");
                buf.append(e.getKey());
                buf.append("\n");
            }
            return buf.toString();
        }

        @Override
        public void close() {
            this.stop();
        }
    }

    public static class SampleSettings {
        private boolean traceCalls;

        public boolean isTraceCalls() {
            return this.traceCalls;
        }

        public void setTraceCalls(boolean traceCalls) {
            this.traceCalls = traceCalls;
        }
    }
}

