/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class Parameters
implements Iterable<Map.Entry<String, String>> {
    private final ArrayList<String> keys = new ArrayList();
    private final ArrayList<String> values = new ArrayList();

    public boolean containsKey(String key) {
        return this.keys.contains(key);
    }

    public int size() {
        return this.keys.size();
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public String get(String key) {
        int index = this.keys.indexOf(key);
        return index != -1 ? this.values.get(index) : null;
    }

    public void put(String key, String value) {
        int index = this.keys.indexOf(key);
        if (index != -1) {
            this.values.set(index, value);
        } else {
            this.add(key, value);
        }
    }

    public void add(String key, String value) {
        this.keys.add(key);
        this.values.add(value);
    }

    public void remove(String key) {
        int index = this.keys.indexOf(key);
        if (index != -1) {
            this.keys.remove(index);
            this.values.remove(index);
        }
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return new ParametersIterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : this) {
            if (sb.length() == 0) {
                sb.append("{");
            } else {
                sb.append(", ");
            }
            sb.append(e.toString());
        }
        return sb.toString();
    }

    private class ParametersIterator
    implements Iterator<Map.Entry<String, String>> {
        private int index;

        @Override
        public boolean hasNext() {
            return this.index < Parameters.this.keys.size();
        }

        @Override
        public Map.Entry<String, String> next() {
            if (this.index >= Parameters.this.keys.size()) {
                throw new NoSuchElementException();
            }
            return new Pair(this.index++);
        }
    }

    private class Pair
    implements Map.Entry<String, String> {
        private final int index;

        Pair(int index) {
            this.index = index;
        }

        @Override
        public final String getKey() {
            return Parameters.this.keys.get(this.index);
        }

        @Override
        public final String getValue() {
            return Parameters.this.values.get(this.index);
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
        }

        @Override
        public final String setValue(String newValue) {
            String oldValue = this.getValue();
            Parameters.this.values.set(this.index, newValue);
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                if (Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue())) {
                    return true;
                }
            }
            return false;
        }
    }
}

