/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.util;

import java.awt.Component;
import java.awt.Dialog;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.FocusManager;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.jalbum.util.Task;
import se.datadosen.component.VerticalLayout;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.util.Debug;

public class MonitoredWorkQueue<T> {
    private ExecutorService executor = Executors.newWorkStealingPool();
    private int millisToPopup = 500;
    Component parentComponent;
    private String message = "";
    private final JLabel messageLabel = new JLabel();
    protected String title;
    protected JDialog dialog;
    private boolean aborted;
    private JProgressBar progressBar = new JProgressBar();
    private Integer maximum;
    private Consumer<Throwable> errorHandler;
    private boolean allowInterrupt = true;
    private int parallelism = Runtime.getRuntime().availableProcessors();
    private Consumer<Dialog> onDialogOpening;
    protected Component focusOwner;

    public MonitoredWorkQueue(Component parentComponent, String title) {
        this.parentComponent = parentComponent;
        this.title = title;
    }

    public MonitoredWorkQueue(Component parentComponent, String message, String title) {
        this.parentComponent = parentComponent;
        this.setMessage(message);
        this.title = title;
    }

    public Integer getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Integer maximum) {
        this.maximum = maximum;
        this.progressBar.setMaximum(maximum);
    }

    public void setValue(int value) {
        this.progressBar.setValue(value);
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.executor = Executors.newWorkStealingPool(parallelism);
        this.parallelism = parallelism;
    }

    public Future<T> submit(Task task) {
        return this.submit(() -> {
            task.call();
            return null;
        });
    }

    public Future<T> submit(final Callable<T> task) {
        Future future = this.executor.submit(new Callable<T>(){
            final /* synthetic */ MonitoredWorkQueue this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T call() throws Exception {
                try {
                    return task.call();
                }
                catch (OperationAbortedException ex) {
                    this.this$0.abort();
                    throw ex;
                }
                catch (Exception ex) {
                    if (!this.this$0.isAborted()) {
                        this.this$0.abort();
                        if (this.this$0.errorHandler != null) {
                            this.this$0.errorHandler.accept(ex);
                        } else {
                            SwingUtilities.invokeLater(() -> Debug.showErrorDialog(this.this$0.parentComponent, ex));
                        }
                    }
                    throw ex;
                }
            }
        });
        return future;
    }

    public void onError(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.messageLabel.setText(message);
    }

    public void abort() {
        if (this.allowInterrupt) {
            this.executor.shutdownNow();
        } else {
            this.executor.shutdown();
        }
        this.aborted = true;
    }

    public boolean isAllowInterrupt() {
        return this.allowInterrupt;
    }

    public void setAllowInterrupt(boolean allowInterrupt) {
        this.allowInterrupt = allowInterrupt;
    }

    protected void dialogOpening() {
    }

    public MonitoredWorkQueue onDialogOpening(Consumer<Dialog> onDialogOpening) {
        this.onDialogOpening = onDialogOpening;
        return this;
    }

    protected void dialogClosed() {
    }

    public void awaitCompletion() {
        this.executor.shutdown();
        try {
            boolean terminatedNormally = this.executor.awaitTermination(this.millisToPopup, TimeUnit.MILLISECONDS);
            if (!terminatedNormally) {
                JPanel content = new JPanel(new VerticalLayout(8));
                content.add(this.messageLabel);
                if (this.maximum == null) {
                    this.progressBar.setIndeterminate(true);
                }
                content.add(this.progressBar);
                String abortString = Msg.get("abort");
                JOptionPane op = new JOptionPane(content, -1, 2, null, new Object[]{abortString});
                this.dialog = op.createDialog(this.parentComponent, this.title);
                BackgroundThread.invoke(() -> {
                    try {
                        this.executor.awaitTermination(1L, TimeUnit.DAYS);
                        this.dialog.setVisible(false);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                });
                if (!this.executor.isTerminated()) {
                    this.focusOwner = FocusManager.getCurrentManager().getFocusOwner();
                    this.dialogOpening();
                    if (this.onDialogOpening != null) {
                        this.onDialogOpening.accept(this.dialog);
                    }
                    this.dialog.setVisible(true);
                    if (this.focusOwner != null) {
                        this.focusOwner.requestFocus();
                    }
                    SwingUtilities.invokeLater(() -> this.dialogClosed());
                }
                if (op.getValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    this.abort();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setMillisToPopup(int millisToPopup) {
        this.millisToPopup = millisToPopup;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    private static class BackgroundThread {
        private BackgroundThread() {
        }

        public static Thread invoke(Runnable r) {
            Thread bgThread = new Thread(r, "Background thread");
            bgThread.setDaemon(true);
            bgThread.start();
            return bgThread;
        }
    }
}

