/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.util;

import com.inet.jortho.FileUserDictionary;
import com.inet.jortho.WordIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Scanner;
import java.util.Set;

public class ExtendedFileUserDictionary
extends FileUserDictionary {
    protected File commonWordsFile;
    protected Set<String> commonWords = new HashSet<String>();

    public ExtendedFileUserDictionary(File commonWordsFile) {
        this.commonWordsFile = commonWordsFile;
        this.init();
    }

    public ExtendedFileUserDictionary(String fileBase, File commonWordsFile) {
        super(fileBase);
        this.commonWordsFile = commonWordsFile;
        this.init();
    }

    public Iterator<String> getWords(Locale locale) {
        this.file = new File(this.fileBase + "UserDictionary_" + String.valueOf(locale) + ".txt");
        try {
            InputStream input = this.file.exists() ? new SequenceInputStream(new FileInputStream(this.commonWordsFile), new FileInputStream(this.file)) : new FileInputStream(this.commonWordsFile);
            return new WordIterator(input, "UTF8");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setUserWords(String wordList) {
        StringBuilder buf = new StringBuilder();
        Scanner sc = new Scanner(wordList);
        while (sc.hasNextLine()) {
            String word = sc.nextLine();
            if (this.commonWords.contains(word)) continue;
            buf.append(word);
            buf.append("\r\n");
        }
        super.setUserWords(buf.toString());
    }

    private void init() {
        try {
            Scanner sc = new Scanner(this.commonWordsFile);
            while (sc.hasNextLine()) {
                this.commonWords.add(sc.nextLine());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

