/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import se.datadosen.util.NamedThreadFactory;

public class Animator {
    private List<Control> animations = new ArrayList<Control>();
    private List<Control> pendingAnimations = new ArrayList<Control>();
    private static final int TIME_DELAY = 16;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new NamedThreadFactory("Animator"));
    private Future job;
    private static Animator instance;

    private Animator() {
    }

    public static Animator getInstance() {
        if (instance == null) {
            instance = new Animator();
        }
        return instance;
    }

    public synchronized Control playFor(int totalDuration, Consumer<Control> animation) {
        Control ctrl = new Control(totalDuration, animation);
        this.pendingAnimations.add(ctrl);
        if (this.job == null || this.job.isDone()) {
            this.job = this.executorService.submit(() -> {
                while (!this.pendingAnimations.isEmpty() || !this.animations.isEmpty()) {
                    if (!this.pendingAnimations.isEmpty()) {
                        Animator animator = this;
                        synchronized (animator) {
                            this.animations.addAll(this.pendingAnimations);
                            this.pendingAnimations.clear();
                        }
                    }
                    Iterator<Control> it = this.animations.iterator();
                    while (it.hasNext()) {
                        try {
                            Control c = it.next();
                            if (c.isAborted()) {
                                it.remove();
                                continue;
                            }
                            c.animation.accept(c);
                            if ((c.currentTime == c.totalDuration && !c.autoReverse || c.currentTime == 0 && c.reversing) && c.cycleCount == 1) {
                                it.remove();
                                if (c.onDone == null) continue;
                                c.onDone.run();
                                continue;
                            }
                            if (c.currentTime == c.totalDuration) {
                                if (c.autoReverse) {
                                    c.reversing = true;
                                } else {
                                    --c.cycleCount;
                                    c.currentTime = 0;
                                }
                            } else if (c.currentTime == 0 && c.reversing) {
                                --c.cycleCount;
                                c.reversing = false;
                            }
                            c.currentTime = c.currentTime + (c.reversing ? -16 : 16);
                            if (c.currentTime > c.totalDuration) {
                                c.currentTime = c.totalDuration;
                            }
                            if (c.currentTime >= 0) continue;
                            c.currentTime = 0;
                        }
                        catch (Throwable t) {
                            t.printStackTrace(System.err);
                            it.remove();
                        }
                    }
                    try {
                        Thread.sleep(16L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
        }
        return ctrl;
    }

    public static class Control {
        private int currentTime;
        private int totalDuration;
        private int cycleCount = 1;
        private boolean autoReverse;
        private boolean reversing;
        private boolean aborted;
        private Consumer<Control> animation;
        private Runnable onDone;

        public Control(int totalDuration, Consumer<Control> animation) {
            this.totalDuration = totalDuration;
            this.animation = animation;
        }

        public int getCycleCount() {
            return this.cycleCount;
        }

        public Control setCycleCount(int cycleCount) {
            this.cycleCount = cycleCount;
            return this;
        }

        public boolean isAutoReverse() {
            return this.autoReverse;
        }

        public Control setAutoReverse(boolean autoReverse) {
            this.autoReverse = autoReverse;
            return this;
        }

        public boolean isReversing() {
            return this.reversing;
        }

        public Control setReversing(boolean reversing) {
            this.reversing = reversing;
            return this;
        }

        public int getCurrentTime() {
            return this.currentTime;
        }

        public int getTotalDuration() {
            return this.totalDuration;
        }

        public float getCurrentTimeNormalized() {
            return (float)this.currentTime / (float)this.totalDuration;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public void abort() {
            this.aborted = true;
        }

        public void onDone(Runnable onDone) {
            this.onDone = onDone;
        }
    }
}

