/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.jalbum.undo.LocalizedUndoableEdit;
import net.jalbum.undo.UndoRedoException;

public abstract class UndoableNamedEdit
extends LocalizedUndoableEdit {
    private final String presentationName;

    public UndoableNamedEdit(String presentationName) {
        this.presentationName = presentationName;
    }

    @Override
    public String getPresentationName() {
        return this.presentationName;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.doRedo();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UndoRedoException(ex);
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        try {
            this.doUndo();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UndoRedoException(ex);
        }
    }

    public abstract void doUndo() throws Exception;

    public abstract void doRedo() throws Exception;
}

