/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.undo;

import java.io.IOException;
import java.util.HashSet;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.jalbum.undo.LocalizedUndoableEdit;
import net.jalbum.undo.UndoRedoException;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.Msg;

public class UndoableDeleteEdit
extends LocalizedUndoableEdit {
    private final AlbumObject ao;
    private final String parentPath;
    private final int position;

    public UndoableDeleteEdit(AlbumObject ao) {
        this.ao = ao;
        AlbumObject parent = ao.getParent();
        this.parentPath = parent.getPathFromRoot();
        this.position = parent.getChildren().indexOf(ao);
        if (this.position == -1) {
            throw new RuntimeException("-1 index for " + String.valueOf(ao));
        }
    }

    @Override
    public String getPresentationName() {
        return Msg.get("edit.deletionOf", this.ao.getName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        try {
            AlbumObject parent = ((AlbumObjectImpl)this.getRoot(this.ao)).getChild(this.parentPath, true);
            this.ao.getFile().mkdir();
            HashSet<AlbumObject> set = new HashSet<AlbumObject>();
            set.add(this.ao);
            parent.add(this.position, set);
            parent.fireModelChanged();
        }
        catch (IOException ex) {
            throw new UndoRedoException(ex);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            AlbumObject parent = this.ao.getParent();
            this.ao.delete();
            parent.fireModelChanged();
        }
        catch (IOException ex) {
            throw new UndoRedoException(ex);
        }
    }

    private AlbumObject getRoot(AlbumObject ao) {
        AlbumObject parent = ao.getParent();
        if (parent == null) {
            return ao;
        }
        return this.getRoot(parent);
    }
}

