/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.undo;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import net.jalbum.undo.UndoNotifier;
import net.jalbum.undo.UndoRedoException;
import net.jalbum.undo.UndoableNamedEdit;
import net.jalbum.util.Task;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;

public class UndoHandler
implements UndoNotifier {
    private static UndoHandler theInstance;
    private static DummyNotifier dummyNotifier;
    private final MyUndoManager undoManager = new MyUndoManager();
    private final UpdateableAction undoAction = new UpdateableAction(null, Icons.small("undo")){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UndoHandler.this.undoManager.undo();
            }
            catch (UndoRedoException ex) {
                Debug.showErrorDialog(JAlbumContext.getInstance().getFrame(), ex);
            }
            finally {
                UndoHandler.this.undoAction.update();
                UndoHandler.this.redoAction.update();
            }
        }

        @Override
        public void update() {
            this.setEnabled(UndoHandler.this.undoManager.canUndo());
            this.putValue("Name", this.isEnabled() ? UndoHandler.this.undoManager.getUndoPresentationName() : Msg.get("edit.undo"));
        }
    };
    private final UpdateableAction redoAction = new UpdateableAction(null, Icons.small("redo")){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x40));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UndoHandler.this.undoManager.redo();
            }
            catch (UndoRedoException ex) {
                Debug.showErrorDialog(JAlbumContext.getInstance().getFrame(), ex);
            }
            finally {
                UndoHandler.this.undoAction.update();
                UndoHandler.this.redoAction.update();
            }
        }

        @Override
        public void update() {
            this.setEnabled(UndoHandler.this.undoManager.canRedo());
            this.putValue("Name", this.isEnabled() ? UndoHandler.this.undoManager.getRedoPresentationName() : Msg.get("edit.redo"));
        }
    };

    private UndoHandler() {
    }

    public static UndoHandler getInstance() {
        if (theInstance == null) {
            theInstance = new UndoHandler();
        }
        return theInstance;
    }

    public static UndoNotifier getDummyNotifier() {
        if (dummyNotifier == null) {
            dummyNotifier = new DummyNotifier();
        }
        return dummyNotifier;
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    public void discardAllEdits() {
        this.undoManager.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    public void update() {
        this.undoAction.update();
        this.redoAction.update();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.isUndoing() || this.isRedoing()) {
            return;
        }
        this.undoManager.undoableEditHappened(e);
        this.undoAction.update();
        this.redoAction.update();
    }

    @Override
    public void undoableEditHappened(Object source, UndoableEdit edit) {
        this.undoableEditHappened(new UndoableEditEvent(source, edit));
    }

    @Override
    public void undoableEditHappened(Object source, String name, final Task onUndo, final Task onRedo) {
        this.undoableEditHappened(source, new UndoableNamedEdit(this, name){
            final /* synthetic */ UndoHandler this$0;
            {
                this.this$0 = this$0;
                super(presentationName);
            }

            @Override
            public void doUndo() throws Exception {
                onUndo.call();
            }

            @Override
            public void doRedo() throws Exception {
                onRedo.call();
            }
        });
    }

    public boolean isRedoing() {
        StackTraceElement[] callStack;
        for (StackTraceElement e : callStack = Thread.currentThread().getStackTrace()) {
            if (!"redo".equals(e.getMethodName())) continue;
            return true;
        }
        return false;
    }

    public boolean isUndoing() {
        StackTraceElement[] callStack;
        for (StackTraceElement e : callStack = Thread.currentThread().getStackTrace()) {
            if (!"undo".equals(e.getMethodName())) continue;
            return true;
        }
        return false;
    }

    private static class MyUndoManager
    extends UndoManager {
        private MyUndoManager() {
        }

        public boolean isLastEditGroup() {
            UndoableEdit lastEdit = super.lastEdit();
            return lastEdit instanceof CompoundEdit;
        }
    }

    private static abstract class UpdateableAction
    extends AbstractAction {
        public UpdateableAction(String name, Icon icon) {
            super(name, icon);
        }

        public UpdateableAction() {
            this.update();
        }

        public abstract void update();
    }

    private static class DummyNotifier
    implements UndoNotifier {
        private DummyNotifier() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
        }

        @Override
        public void undoableEditHappened(Object source, UndoableEdit edit) {
        }

        @Override
        public void undoableEditHappened(Object source, String name, Task onUndo, Task onRedo) {
        }
    }
}

