/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.review;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.jalbum.review.FlexibleStrokeBorder;
import net.jalbum.review.JThumbnailStrip;
import net.jalbum.util.Animator;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.JAlbumColor;

class JMovingPanel
extends JPanel {
    ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(1);
    Future mouseChecker;
    private boolean hidden;
    private final Border topBorder = new FlexibleStrokeBorder(new BasicStroke(4.0f), null, null, null, this.createChequeredPaint(JAlbumColor.textText));
    private int yOffset = 0;
    private Consumer<Point> visibilityHandler;

    public boolean isHidden() {
        return this.hidden;
    }

    private TexturePaint createChequeredPaint(Color c) {
        int s = 4;
        BufferedImage im = new BufferedImage(2 * s, 2 * s, 6);
        Graphics2D g = im.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(c);
        g.fillRect(0, 0, s, s);
        g.fillRect(s, s, s, s);
        g.dispose();
        return new TexturePaint(im, new Rectangle(0, 0, s, s));
    }

    public void setHidden(boolean hidden) {
        if (this.hidden != hidden) {
            Insets in = this.getInsets();
            if (hidden) {
                this.hidden = true;
                Animator.getInstance().playFor(180, ctrl -> {
                    this.yOffset = (int)((float)(this.getHeight() - in.top) * ctrl.getCurrentTimeNormalized());
                    if (this.getParent() != null) {
                        this.getParent().doLayout();
                        this.repaint();
                    }
                });
            } else {
                this.hidden = false;
                Animator.getInstance().playFor(180, ctrl -> {
                    this.yOffset = (int)((float)(this.getHeight() - in.top) * (1.0f - ctrl.getCurrentTimeNormalized()));
                    if (this.getParent() != null) {
                        this.getParent().doLayout();
                        this.repaint();
                    }
                });
            }
        }
    }

    public JMovingPanel() {
        super(new BorderLayout());
        this.init();
    }

    public JMovingPanel(JComponent content) {
        super(new BorderLayout());
        this.setContent(content);
        this.init();
    }

    public final void setContent(JComponent content) {
        this.removeAll();
        this.add(content);
    }

    public JComponent getContent() {
        return (JComponent)this.getComponent(0);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y + this.yOffset, width, height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mouseChecker == null) {
            this.mouseChecker = this.scheduledExecutor.schedule(() -> {
                this.visibilityHandler = p -> this.setHidden(p.y < this.getY());
                PointerInfo pi = MouseInfo.getPointerInfo();
                Point point = pi.getLocation();
                SwingUtilities.convertPointFromScreen(point, this.getParent());
                this.visibilityHandler.accept(point);
            }, 3000L, TimeUnit.MILLISECONDS);
            JThumbnailStrip thumbStrip = (JThumbnailStrip)((JScrollPane)this.getContent()).getViewport().getView();
            JAlbumObject focused = thumbStrip.selectionModel.getFocusedObject();
            if (focused != null) {
                thumbStrip.scrollRectToVisible(focused.getBounds());
            }
        }
    }

    private void init() {
        this.setOpaque(false);
        this.setBorder(this.topBorder);
    }

    void handleVisibility(Point point) {
        if (this.visibilityHandler != null) {
            this.visibilityHandler.accept(point);
        }
    }
}

