/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.review;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JPanel;
import net.jalbum.review.JCloseupPanel;
import net.jalbum.review.ReviewMode;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumObject;

class JCloseupGrid
extends JPanel {
    private final ReviewMode reviewMode;
    private boolean needsRelayout = true;

    public JCloseupGrid(ReviewMode reviewMode) {
        super(new GridLayout(1, 1));
        this.reviewMode = reviewMode;
        reviewMode.thumbStrip.selectionModel.addSelectionListener(model -> {
            this.needsRelayout = true;
            this.repaint();
        });
        this.setOpaque(true);
    }

    int getFirstIndex() {
        return ((JCloseupPanel)this.getComponent((int)0)).index;
    }

    public int getGridSize() {
        GridLayout gl = (GridLayout)this.getLayout();
        return gl.getRows() * gl.getColumns();
    }

    int getCurrentPage() {
        return this.getFirstIndex() / this.getGridSize();
    }

    private void updateLayout() {
        Map panelMap = Stream.of(this.getComponents()).map(comp -> (JCloseupPanel)comp).filter(panel -> panel.getAO() != null).collect(Collectors.toConcurrentMap(comp -> comp.getAO(), comp -> comp));
        List<JAlbumObject> sel = this.reviewMode.thumbStrip.selectionModel.getSelectedObjects();
        if (sel.size() == this.getComponentCount()) {
            int i = 0;
            for (JAlbumObject jao : sel) {
                ((JCloseupPanel)this.getComponents()[i]).setAO(jao.ao);
                ++i;
            }
        } else {
            JCloseupPanel closeup;
            this.removeAll();
            int total = this.adaptLayout(sel.size());
            if (sel.size() > total) {
                sel = sel.subList(0, total);
            }
            JCloseupPanel[] newPanels = new JCloseupPanel[total];
            int i = 0;
            for (JAlbumObject jao : sel) {
                closeup = (JCloseupPanel)panelMap.remove(jao.ao);
                if (closeup != null) {
                    closeup.setAO(jao.ao);
                }
                newPanels[i++] = closeup;
            }
            ArrayList remainingPanels = new ArrayList(panelMap.values());
            for (i = 0; i < newPanels.length; ++i) {
                if (newPanels[i] == null) {
                    AlbumObject ao = null;
                    if (i < sel.size()) {
                        ao = sel.get((int)i).ao;
                    }
                    if (!remainingPanels.isEmpty()) {
                        closeup = (JCloseupPanel)remainingPanels.remove(0);
                        closeup.setAO(ao);
                    } else {
                        closeup = new JCloseupPanel(this.reviewMode, ao);
                    }
                    newPanels[i] = closeup;
                }
                this.add(newPanels[i]);
            }
            this.validate();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.needsRelayout) {
            this.needsRelayout = false;
            this.updateLayout();
        }
    }

    private int adaptLayout(int nComponents) {
        int rows = 1;
        int cols = 1;
        if (nComponents > 2) {
            rows = 2;
            cols = (nComponents + 1) / rows;
        } else {
            cols = nComponents;
        }
        if (cols > 3) {
            cols = 3;
        }
        GridLayout gl = (GridLayout)this.getLayout();
        gl.setColumns(cols);
        gl.setRows(rows);
        return rows * cols;
    }

    void handleGlassPanelVisibility(boolean show) {
        for (Component c : this.getComponents()) {
            JCloseupPanel closeup = (JCloseupPanel)c;
            closeup.handleGlassPanelVisibility(show);
        }
    }
}

