/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.resty.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import net.jalbum.resty.web.AbstractContent;
import net.jalbum.resty.web.AbstractResource;
import net.jalbum.resty.web.FormContent;
import net.jalbum.resty.web.Resty;
import net.jalbum.resty.web.RobustTextResource;
import net.jalbum.resty.web.RobustXMLResource;

public class RobustResty
extends Resty {
    private final int connectTimeout;
    private final int readTimeout;

    public RobustResty() {
        this(5000, 10000);
    }

    public RobustResty(int connectTimeout, int readTimeout) {
        super(new Resty.Option[0]);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    protected <T extends AbstractResource> URLConnection openConnection(URI anUri, T resource) throws IOException, MalformedURLException {
        URLConnection conn = super.openConnection(anUri, resource);
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        return conn;
    }

    public RobustTextResource text(URI anUri) throws IOException {
        return (RobustTextResource)this.doGET(anUri, (AbstractResource)new RobustTextResource());
    }

    public RobustTextResource text(URI anUri, AbstractContent content) throws IOException {
        return (RobustTextResource)this.doPOSTOrPUT(anUri, content, (AbstractResource)new RobustTextResource());
    }

    public RobustXMLResource xml(URI anUri) throws IOException {
        return (RobustXMLResource)this.doGET(anUri, (AbstractResource)new RobustXMLResource());
    }

    public RobustXMLResource xml(URI anUri, AbstractContent requestContent) throws IOException {
        return (RobustXMLResource)this.doPOSTOrPUT(anUri, requestContent, (AbstractResource)new RobustXMLResource());
    }

    public static FormContent form(Map data) {
        FormContent fc = new FormContent(RobustResty.encodeFormData(data));
        return fc;
    }

    private static String encodeFormData(Map data) {
        try {
            Object result = "";
            for (Map.Entry e : data.entrySet()) {
                if (!((String)result).isEmpty()) {
                    result = (String)result + "&";
                }
                result = (String)result + URLEncoder.encode(e.getKey().toString(), "UTF-8") + "=" + URLEncoder.encode(e.getValue().toString(), "UTF-8");
            }
            return result;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

