/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.remotefs.ftp4j;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.util.debug.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import net.jalbum.remotefs.FtpFile;
import net.jalbum.remotefs.RemoteFS;
import net.jalbum.remotefs.RemoteFSException;
import net.jalbum.remotefs.RemoteFSProgressMonitor;
import net.jalbum.remotefs.RemoteFile;
import se.datadosen.jalbum.Config;

public class FtpAdapter
implements RemoteFS {
    private FTPClient ftpClient = new FTPClient();
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private Set<String> features = new HashSet<String>();

    private static void setLoggingLevel(Level level) {
        com.enterprisedt.util.debug.Level l = com.enterprisedt.util.debug.Level.getLevel((String)level.getName());
        if (l == null) {
            l = Config.getConfig().isDebugMode() ? com.enterprisedt.util.debug.Level.DEBUG : com.enterprisedt.util.debug.Level.OFF;
        }
        Logger.setLevel((com.enterprisedt.util.debug.Level)l);
    }

    private boolean isSupported(String feature) {
        return this.features.contains(feature);
    }

    public FtpAdapter() {
        try {
            this.ftpClient.setControlEncoding(DEFAULT_ENCODING);
            String ftpLocale = System.getProperty("ftp.locale");
            if (ftpLocale != null) {
                this.ftpClient.setParserLocale(new Locale(ftpLocale));
            } else {
                this.ftpClient.setParserLocale(Locale.ENGLISH);
            }
        }
        catch (FTPException fTPException) {
            // empty catch block
        }
    }

    @Override
    public void setPort(int port) {
        try {
            this.ftpClient.setRemotePort(port);
        }
        catch (FTPException fTPException) {
            // empty catch block
        }
    }

    @Override
    public int getPort() {
        return this.ftpClient.getRemotePort();
    }

    @Override
    public void setForceUTF8(boolean force) {
        try {
            if (force) {
                this.ftpClient.setControlEncoding("UTF-8");
            } else {
                this.ftpClient.setControlEncoding(DEFAULT_ENCODING);
            }
        }
        catch (FTPException fTPException) {
            // empty catch block
        }
    }

    @Override
    public boolean isForceUTF8() {
        return "UTF-8".equals(this.ftpClient.getControlEncoding());
    }

    @Override
    public void setPassiveMode(boolean passive) {
        if (passive) {
            this.ftpClient.setConnectMode(FTPConnectMode.PASV);
        } else {
            this.ftpClient.setConnectMode(FTPConnectMode.ACTIVE);
        }
    }

    @Override
    public boolean isPassiveMode() {
        return this.ftpClient.getConnectMode() == FTPConnectMode.PASV;
    }

    @Override
    public String getDirectory() throws RemoteFSException, IOException {
        try {
            return this.ftpClient.pwd();
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void rename(String from, String to) throws RemoteFSException, IOException {
        try {
            this.ftpClient.rename(from, to);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void setDirectory(String directory) throws RemoteFSException, IOException {
        try {
            this.ftpClient.chdir(directory);
        }
        catch (FTPException ex) {
            if (ex.getReplyCode() == 421) {
                throw new IOException(ex.getMessage());
            }
            throw new RemoteFSException("For directory '" + directory + "'", ex);
        }
    }

    @Override
    public void toParentDirectory() throws IOException, RemoteFSException {
        try {
            this.ftpClient.cdup();
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void createDirectory(String name) throws IOException, RemoteFSException {
        try {
            this.ftpClient.mkdir(name);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void removeDirectory(String name) throws IOException, RemoteFSException {
        try {
            this.ftpClient.rmdir(name);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void connect(String server, String user, String password) throws IOException, RemoteFSException {
        try {
            this.ftpClient.setRemoteHost(server);
            this.ftpClient.connect();
            this.ftpClient.login(user, password);
            this.ftpClient.setType(FTPTransferType.BINARY);
            this.ftpClient.setTimeout(10000);
            this.ftpClient.setRetryCount(0);
            for (String feat : this.ftpClient.features()) {
                this.features.add(feat);
            }
        }
        catch (FTPException ex) {
            try {
                this.ftpClient.quit();
            }
            catch (FTPException | IOException throwable) {
                // empty catch block
            }
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void disconnect() throws IOException, RemoteFSException {
        try {
            this.ftpClient.quit();
        }
        catch (IOException ex) {
            try {
                this.ftpClient.quitImmediately();
            }
            catch (FTPException ex1) {
                throw new RemoteFSException(ex1);
            }
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public boolean isConnected() {
        return this.ftpClient != null && this.ftpClient.connected();
    }

    @Override
    public RemoteFile[] getFiles() throws IOException, RemoteFSException {
        return this.getFiles(".");
    }

    @Override
    public RemoteFile[] getFiles(String dir) throws IOException, RemoteFSException {
        try {
            FTPFile[] files;
            FTPFile[] fTPFileArray = files = this.isSupported("MLSD") ? this.ftpClient.dirDetailsM(dir) : this.ftpClient.dirDetails(dir);
            if (files.length == 0 && dir.indexOf(32) >= 0) {
                System.err.println("WARNING: FTP server isn't supporting MLSD command. Listing directories containing spaces is likely to fail, causing side effects like full re-uploads. Switch to the ftp4j connection type!");
            }
            RemoteFile[] finalFiles = new FtpFile[files.length];
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                long size = files[i].size();
                Date date = files[i].lastModified();
                finalFiles[i] = new FtpFile(name, size, date, files[i].isDir(), files[i].isLink());
            }
            return finalFiles;
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        catch (FTPException e) {
            throw new RemoteFSException(e);
        }
    }

    @Override
    public void putFile(File file) throws IOException, RemoteFSException {
        try {
            this.ftpClient.put(file.getAbsolutePath(), file.getName());
        }
        catch (FTPException ex) {
            if (ex.getReplyCode() == 530) {
                System.err.println("FTP put returned 'Not logged in'. Retrying");
                throw new IOException(ex);
            }
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void putFile(File file, String path) throws IOException, RemoteFSException {
        try {
            this.ftpClient.put(file.getAbsolutePath(), path);
        }
        catch (FTPException ex) {
            int rc = ex.getReplyCode();
            if (rc == 530) {
                System.err.println("FTP put returned 'Not logged in'. Retrying");
                throw new IOException(ex);
            }
            if (rc == 425) {
                System.err.println("FTP put returned 'Couldn't create data socket. Retrying");
                throw new IOException(ex);
            }
            if (rc == 421) {
                throw new IOException(ex.getMessage());
            }
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void put(InputStream in, String path) throws IOException, RemoteFSException {
        try {
            this.ftpClient.put(in, path);
        }
        catch (FTPException ex) {
            if (ex.getReplyCode() == 530) {
                System.err.println("FTP put returned 'Not logged in'. Retrying");
                throw new IOException(ex);
            }
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void get(String path, OutputStream out) throws IOException, RemoteFSException {
        try {
            this.ftpClient.get(out, path);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void removeFile(String filename) throws IOException, RemoteFSException {
        try {
            this.ftpClient.delete(filename);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void setProgressMonitor(RemoteFSProgressMonitor monitor) {
        this.ftpClient.setProgressMonitor(monitor::bytesTransferred);
    }

    @Override
    public void abortConnect() throws IOException, RemoteFSException {
        try {
            this.ftpClient.quitImmediately();
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public boolean exists(String path) throws IOException, RemoteFSException {
        try {
            boolean exists = this.ftpClient.existsFile(path);
            return exists;
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public boolean existsDirectory(String path) throws IOException, RemoteFSException {
        try {
            boolean exists = this.ftpClient.existsDirectory(path);
            return exists;
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void getUnmonitored(String path, OutputStream out) throws IOException, RemoteFSException {
        throw new RemoteFSException("Not supported");
    }

    @Override
    public void noop() throws IOException, RemoteFSException {
        try {
            this.ftpClient.noOperation();
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    static {
        FtpAdapter.setLoggingLevel(Level.OFF);
    }
}

