/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.remotefs.ftp4j;

import it.sauronsoftware.ftp4j.FTPAbortedException;
import it.sauronsoftware.ftp4j.FTPClient;
import it.sauronsoftware.ftp4j.FTPDataTransferException;
import it.sauronsoftware.ftp4j.FTPDataTransferListener;
import it.sauronsoftware.ftp4j.FTPException;
import it.sauronsoftware.ftp4j.FTPFile;
import it.sauronsoftware.ftp4j.FTPIllegalReplyException;
import it.sauronsoftware.ftp4j.FTPListParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.jalbum.remotefs.FtpFile;
import net.jalbum.remotefs.RemoteFS;
import net.jalbum.remotefs.RemoteFSException;
import net.jalbum.remotefs.RemoteFSProgressMonitor;
import net.jalbum.remotefs.RemoteFile;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.TransferProtocol;
import se.datadosen.util.IO;

public class Ftp4jAdapter
implements RemoteFS {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private FTPClient ftpClient = new FTPClient();
    private int port;
    private FTPDataTransferListener monitor = null;
    private int ftpSecurity = 0;
    private boolean abortConnect;

    public Ftp4jAdapter(TransferProtocol protocol) {
        switch (protocol) {
            case ftp: {
                this.ftpSecurity = 0;
                break;
            }
            case ftps: {
                this.ftpSecurity = 1;
                break;
            }
            case ftpes: {
                this.ftpSecurity = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Protocol " + String.valueOf((Object)protocol) + " not supported by ftp4j");
            }
        }
        this.ftpClient.setCharset(DEFAULT_ENCODING);
        if (protocol == TransferProtocol.ftps || protocol == TransferProtocol.ftpes) {
            TrustManager[] trustManager = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustManager, new SecureRandom());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            this.ftpClient.setSSLSocketFactory(sslSocketFactory);
            this.ftpClient.setSecurity(this.ftpSecurity);
        }
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.ftpClient.getPort();
    }

    @Override
    public void setForceUTF8(boolean force) {
        if (force) {
            this.ftpClient.setCharset("UTF-8");
        } else {
            this.ftpClient.setCharset(DEFAULT_ENCODING);
        }
    }

    @Override
    public boolean isForceUTF8() {
        return "UTF-8".equals(this.ftpClient.getCharset());
    }

    @Override
    public void setPassiveMode(boolean passive) {
        this.ftpClient.setPassive(passive);
    }

    @Override
    public boolean isPassiveMode() {
        return this.ftpClient.isPassive();
    }

    @Override
    public String getDirectory() throws RemoteFSException, IOException {
        try {
            return this.ftpClient.currentDirectory();
        }
        catch (FTPIllegalReplyException | IllegalStateException ex) {
            throw new IOException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void rename(String from, String to) throws RemoteFSException, IOException {
        try {
            this.ftpClient.rename(from, to);
        }
        catch (FTPIllegalReplyException | IllegalStateException ex) {
            throw new IOException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void setDirectory(String directory) throws RemoteFSException, IOException {
        try {
            this.ftpClient.changeDirectory(directory);
        }
        catch (FTPIllegalReplyException | IllegalStateException ex) {
            throw new IOException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException("For directory '" + directory + "'", ex);
        }
    }

    @Override
    public void toParentDirectory() throws IOException, RemoteFSException {
        try {
            this.ftpClient.changeDirectoryUp();
        }
        catch (FTPIllegalReplyException | IllegalStateException ex) {
            throw new IOException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void createDirectory(String name) throws IOException, RemoteFSException {
        try {
            this.ftpClient.createDirectory(name);
        }
        catch (FTPIllegalReplyException | IllegalStateException ex) {
            throw new IOException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void removeDirectory(String name) throws IOException, RemoteFSException {
        try {
            this.ftpClient.deleteDirectory(name);
        }
        catch (FTPIllegalReplyException | IllegalStateException ex) {
            throw new IOException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void connect(String server, String user, String password) throws IOException, RemoteFSException {
        try {
            String[] result = this.ftpClient.connect(server, this.port);
            if (JAlbum.logger.isLoggable(Level.FINER)) {
                System.out.println("Server welcome message:");
                for (String line : result) {
                    System.out.println(line);
                }
            }
            this.ftpClient.login(user, password);
            this.ftpClient.setType(2);
            this.ftpClient.setAutoNoopTimeout(30000L);
            if (this.abortConnect) {
                this.ftpClient.disconnect(false);
                throw new IOException("Connection aborted");
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (FTPIllegalReplyException | IllegalStateException ex) {
            throw new IOException(ex);
        }
        catch (FTPException ex) {
            try {
                this.ftpClient.disconnect(false);
            }
            catch (FTPException | FTPIllegalReplyException throwable) {
                // empty catch block
            }
            throw new RemoteFSException(ex);
        }
        finally {
            this.abortConnect = false;
        }
    }

    @Override
    public void disconnect() throws IOException, RemoteFSException {
        try {
            if (this.isConnected()) {
                try {
                    this.ftpClient.disconnect(true);
                }
                catch (Throwable t) {
                    this.ftpClient.disconnect(false);
                }
            }
        }
        catch (IllegalStateException t) {
        }
        catch (FTPIllegalReplyException ex1) {
            throw new IOException(ex1);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public boolean isConnected() {
        return this.ftpClient.isConnected();
    }

    @Override
    public RemoteFile[] getFiles() throws IOException, RemoteFSException {
        return this.getFiles(".");
    }

    @Override
    public RemoteFile[] getFiles(String dir) throws IOException, RemoteFSException {
        try {
            FTPFile[] files = this.ftpClient.list(dir);
            RemoteFile[] finalFiles = new FtpFile[files.length];
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                long size = files[i].getSize();
                Date date = files[i].getModifiedDate();
                finalFiles[i] = new FtpFile(name, size, date, files[i].getType() == 1, files[i].getType() == 2);
            }
            return finalFiles;
        }
        catch (IOException e) {
            throw e;
        }
        catch (FTPDataTransferException | FTPIllegalReplyException | FTPListParseException | IllegalStateException ex) {
            throw new IOException(ex);
        }
        catch (FTPException e) {
            throw new RemoteFSException(e);
        }
        catch (FTPAbortedException ex) {
            throw new OperationAbortedException();
        }
    }

    @Override
    public void putFile(File file) throws IOException, RemoteFSException {
        try {
            this.ftpClient.upload(file, this.monitor);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (FTPDataTransferException | FTPIllegalReplyException | IllegalStateException ex) {
            throw new IOException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPAbortedException ex) {
            throw new OperationAbortedException();
        }
    }

    @Override
    public void putFile(File file, String path) throws IOException, RemoteFSException {
        FileInputStream fis = new FileInputStream(file);
        try {
            this.ftpClient.upload(path, (InputStream)fis, 0L, 0L, this.monitor);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (FTPDataTransferException | FTPIllegalReplyException | IllegalStateException ex) {
            throw new IOException(ex);
        }
        catch (FTPException ex) {
            if (ex.getCode() == 425) {
                System.err.println("Can't open data connection during putFile. Retrying");
                throw new IOException(ex);
            }
            throw new RemoteFSException(ex);
        }
        catch (FTPAbortedException ex) {
            throw new OperationAbortedException();
        }
        finally {
            IO.close(fis);
        }
    }

    @Override
    public void put(InputStream in, String path) throws IOException, RemoteFSException {
        try {
            this.ftpClient.upload(path, in, 0L, 0L, this.monitor);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (FTPDataTransferException | FTPIllegalReplyException | IllegalStateException ex) {
            throw new IOException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPAbortedException ex) {
            throw new OperationAbortedException();
        }
    }

    @Override
    public void get(String path, OutputStream out) throws IOException, RemoteFSException {
        try {
            this.ftpClient.download(path, out, 0L, this.monitor);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (FTPDataTransferException | FTPIllegalReplyException | IllegalStateException ex) {
            throw new IOException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPAbortedException ex) {
            throw new OperationAbortedException();
        }
    }

    @Override
    public void removeFile(String filename) throws IOException, RemoteFSException {
        try {
            this.ftpClient.deleteFile(filename);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (FTPIllegalReplyException | IllegalStateException ex) {
            throw new IOException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    @Override
    public void setProgressMonitor(final RemoteFSProgressMonitor monitor) {
        this.monitor = new FTPDataTransferListener(){
            private long bytesTransferred;
            final /* synthetic */ Ftp4jAdapter this$0;
            {
                this.this$0 = this$0;
            }

            public void started() {
                this.bytesTransferred = 0L;
            }

            public void transferred(int length) {
                this.bytesTransferred += (long)length;
                monitor.bytesTransferred(this.bytesTransferred);
            }

            public void completed() {
            }

            public void aborted() {
            }

            public void failed() {
            }
        };
    }

    @Override
    public void abortConnect() throws IOException, RemoteFSException {
        this.abortConnect = true;
        this.ftpClient.abortCurrentConnectionAttempt();
    }

    @Override
    public boolean exists(String path) throws IOException, RemoteFSException {
        try {
            this.ftpClient.fileSize(path);
            return true;
        }
        catch (FTPException ex) {
            return false;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (FTPIllegalReplyException | IllegalStateException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public boolean existsDirectory(String path) throws IOException, RemoteFSException {
        try {
            String initDir = this.ftpClient.currentDirectory();
            this.ftpClient.changeDirectory(path);
            this.ftpClient.changeDirectory(initDir);
            return true;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (IllegalStateException ex) {
            throw new IOException(ex);
        }
        catch (FTPException | FTPIllegalReplyException ex) {
            return false;
        }
    }

    @Override
    public void getUnmonitored(String path, OutputStream out) throws IOException, RemoteFSException {
        throw new RemoteFSException("Not supported");
    }

    @Override
    public void noop() throws IOException, RemoteFSException {
        try {
            this.ftpClient.noop();
        }
        catch (FTPIllegalReplyException ex) {
            throw new IOException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }
}

