/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.remotefs.commons.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import net.jalbum.remotefs.FtpFile;
import net.jalbum.remotefs.RemoteFS;
import net.jalbum.remotefs.RemoteFSException;
import net.jalbum.remotefs.RemoteFSProgressMonitor;
import net.jalbum.remotefs.RemoteFile;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class CommonsFtpAdapter
implements RemoteFS {
    private final FTPClient client;
    protected int port;
    protected boolean forceUTF8;
    protected boolean passive;
    protected RemoteFSProgressMonitor monitor;

    public CommonsFtpAdapter() {
        this(new FTPClient());
    }

    protected CommonsFtpAdapter(FTPClient client) {
        this.client = client;
    }

    protected FTPClient getClient() {
        return this.client;
    }

    @Override
    public void setPort(int port) throws RemoteFSException {
        this.port = port;
    }

    @Override
    public int getPort() throws RemoteFSException {
        return this.port;
    }

    @Override
    public void setForceUTF8(boolean force) throws RemoteFSException {
        this.forceUTF8 = force;
        if (this.forceUTF8) {
            this.client.setControlEncoding("UTF-8");
        } else {
            this.client.setAutodetectUTF8(true);
        }
    }

    @Override
    public boolean isForceUTF8() throws RemoteFSException {
        return this.forceUTF8;
    }

    @Override
    public void setPassiveMode(boolean passive) throws RemoteFSException {
        this.passive = passive;
    }

    @Override
    public boolean isPassiveMode() throws RemoteFSException {
        return this.passive;
    }

    @Override
    public String getDirectory() throws RemoteFSException, IOException {
        return this.client.printWorkingDirectory();
    }

    @Override
    public void setDirectory(String directory) throws RemoteFSException, IOException {
        boolean success = this.client.changeWorkingDirectory(directory);
        if (!success) {
            throw new RemoteFSException("Couldn't change to directory " + directory);
        }
    }

    @Override
    public void toParentDirectory() throws RemoteFSException, IOException {
        boolean success = this.client.changeToParentDirectory();
        if (!success) {
            throw new RemoteFSException("Couldn't change to parent directory ");
        }
    }

    @Override
    public void createDirectory(String name) throws IOException, RemoteFSException {
        boolean success = this.client.makeDirectory(name);
        if (!success) {
            throw new RemoteFSException("Couldn't create directory " + name);
        }
    }

    @Override
    public void removeDirectory(String name) throws IOException, RemoteFSException {
        boolean success = this.client.removeDirectory(name);
        if (!success) {
            throw new RemoteFSException("Couldn't remove directory " + name);
        }
    }

    @Override
    public void connect(String server, String user, String password) throws IOException, RemoteFSException {
        this.client.connect(server, this.port);
        this.client.login(user, password);
        if (this.passive) {
            this.client.enterLocalPassiveMode();
        } else {
            this.client.enterLocalActiveMode();
        }
        this.client.setFileType(2);
    }

    @Override
    public void abortConnect() throws RemoteFSException, IOException {
        this.client.disconnect();
    }

    @Override
    public void disconnect() throws IOException, RemoteFSException {
        this.client.abort();
        this.client.disconnect();
    }

    @Override
    public boolean isConnected() throws RemoteFSException {
        return this.client.isConnected();
    }

    @Override
    public RemoteFile[] getFiles() throws IOException, RemoteFSException {
        FTPFile[] files = this.client.listFiles();
        return (RemoteFile[])Arrays.stream(files).map(ftpFile -> new FtpFile(ftpFile.getName(), ftpFile.getSize(), new Date(ftpFile.getTimestampInstant().toEpochMilli()), ftpFile.isDirectory(), ftpFile.isSymbolicLink())).toArray(RemoteFile[]::new);
    }

    @Override
    public RemoteFile[] getFiles(String dir) throws IOException, RemoteFSException {
        FTPFile[] files = this.client.listFiles(dir);
        return (RemoteFile[])Arrays.stream(files).map(f -> new FtpFile(f.getName(), f.getSize(), f.getTimestamp().getTime(), f.isDirectory(), f.isSymbolicLink())).toArray(RemoteFile[]::new);
    }

    @Override
    public void noop() throws IOException, RemoteFSException {
        this.client.noop();
    }

    @Override
    public void putFile(File file) throws IOException, RemoteFSException {
        try (CountingInputStream input = new CountingInputStream(new FileInputStream(file));){
            boolean success = this.client.storeFile(file.getName(), (InputStream)input);
            if (!success) {
                throw new RemoteFSException("Couldn't put " + String.valueOf(file));
            }
        }
    }

    @Override
    public void putFile(File file, String path) throws IOException, RemoteFSException {
        try (CountingInputStream input = new CountingInputStream(new FileInputStream(file));){
            boolean success = this.client.storeFile(path, (InputStream)input);
            if (!success) {
                throw new RemoteFSException("Couldn't put " + path);
            }
        }
    }

    @Override
    public void put(InputStream in, String path) throws IOException, RemoteFSException {
        boolean success = this.client.storeFile(path, (InputStream)new CountingInputStream(in));
        if (!success) {
            throw new RemoteFSException("Couldn't put " + path);
        }
    }

    @Override
    public void get(String path, OutputStream out) throws IOException, RemoteFSException {
        boolean success = this.client.retrieveFile(path, (OutputStream)new CountingOutputStream(out));
        if (!success) {
            throw new RemoteFSException("Couldn't get " + path);
        }
    }

    @Override
    public void getUnmonitored(String path, OutputStream out) throws IOException, RemoteFSException {
        boolean success = this.client.retrieveFile(path, out);
        if (!success) {
            throw new RemoteFSException("Couldn't get " + path);
        }
    }

    @Override
    public void removeFile(String filename) throws IOException, RemoteFSException {
        boolean success = this.client.deleteFile(filename);
        if (!success) {
            throw new RemoteFSException("No such file: " + filename);
        }
    }

    @Override
    public void rename(String from, String to) throws IOException, RemoteFSException {
        boolean success = this.client.rename(from, to);
        if (!success) {
            throw new RemoteFSException("Error renaming " + from + " to " + to);
        }
    }

    @Override
    public void setProgressMonitor(RemoteFSProgressMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public boolean exists(String path) throws IOException, RemoteFSException {
        long size = this.client.size(path);
        int reply = this.client.getReplyCode();
        return FTPReply.isPositiveCompletion((int)reply);
    }

    @Override
    public boolean existsDirectory(String path) throws IOException, RemoteFSException {
        String initDir = this.client.printWorkingDirectory();
        boolean res = this.client.changeWorkingDirectory(path);
        if (res) {
            this.client.changeWorkingDirectory(initDir);
        }
        return res;
    }

    private void reportProgress(long bytesTransferred) {
        if (this.monitor != null) {
            this.monitor.bytesTransferred(bytesTransferred);
        }
    }

    private class CountingInputStream
    extends FilterInputStream {
        private long bytesTransferred;

        public long getBytesTransferred() {
            return this.bytesTransferred;
        }

        public CountingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = super.read(b, off, len);
            this.bytesTransferred += (long)read;
            CommonsFtpAdapter.this.reportProgress(this.bytesTransferred);
            return read;
        }

        @Override
        public int read() throws IOException {
            int res = super.read();
            if (res != -1) {
                ++this.bytesTransferred;
                CommonsFtpAdapter.this.reportProgress(this.bytesTransferred);
            }
            return res;
        }
    }

    private class CountingOutputStream
    extends FilterOutputStream {
        private long bytesTransferred;

        public long getBytesTransferred() {
            return this.bytesTransferred;
        }

        public CountingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.bytesTransferred += (long)len;
            CommonsFtpAdapter.this.reportProgress(this.bytesTransferred);
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            ++this.bytesTransferred;
            CommonsFtpAdapter.this.reportProgress(this.bytesTransferred);
        }
    }
}

