/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.remotefs;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import se.datadosen.util.IO;

public abstract class RemoteFile
implements Comparable {
    protected String name;
    protected Date creationDate;
    protected Date modificationDate;
    protected long size;
    private static String dateFormat1 = "MMM d HH:mm";
    private static String dateFormat2 = "MMM d yyyy";

    protected RemoteFile() {
    }

    public abstract boolean isFile();

    public abstract boolean isDirectory();

    public abstract boolean isLink();

    public String getName() {
        return this.name;
    }

    public String getParentPath() {
        return IO.parentPath(this.getFullPath());
    }

    public String getFullPath() {
        return this.getName();
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public long size() {
        return this.size;
    }

    protected Date parseDate(String date) {
        try {
            if (date.indexOf(58) >= 0) {
                SimpleDateFormat df = new SimpleDateFormat(dateFormat1);
                Date d = df.parse(date);
                Calendar cal = Calendar.getInstance();
                int year = cal.get(1);
                cal.setTime(d);
                cal.set(1, year);
                return cal.getTime();
            }
            SimpleDateFormat df = new SimpleDateFormat(dateFormat2);
            Date d = df.parse(date);
            return d;
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.getKey());
        return hash;
    }

    public String getKey() {
        return (this.isDirectory() ? "/" : "") + this.getFullPath();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteFile other = (RemoteFile)obj;
        return Objects.equals(this.getKey(), other.getKey());
    }

    public int compareTo(Object other) {
        return this.getKey().compareTo(((RemoteFile)other).getKey());
    }

    public String toString() {
        return "RemoteFile {" + this.getFullPath() + "\t" + this.size() + "\t" + String.valueOf(this.getModificationDate()) + "}\n";
    }
}

