/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.remotefs;

import net.jalbum.remotefs.RemoteFS;
import net.jalbum.remotefs.commons.ftp.CommonsFtpAdapter;
import net.jalbum.remotefs.commons.ftp.CommonsFtpsAdapter;
import net.jalbum.remotefs.ftp4j.Ftp4jAdapter;
import net.jalbum.remotefs.ftp4j.FtpAdapter;
import net.jalbum.remotefs.sftp.SftpAdapter;
import se.datadosen.jalbum.TransferProtocol;

public class RemoteFSFactory {
    private RemoteFSFactory() {
    }

    public static RemoteFS getRemoteFS(TransferProtocol type) throws IllegalArgumentException {
        switch (type) {
            case ftp: {
                return new FtpAdapter();
            }
            case sftp: {
                return new SftpAdapter();
            }
            case ftps: 
            case ftpes: {
                return new Ftp4jAdapter(type);
            }
            case ftp4j: {
                return new Ftp4jAdapter(TransferProtocol.ftp);
            }
            case commons_ftp: {
                return new CommonsFtpAdapter();
            }
            case commons_ftpes: 
            case commons_ftps: {
                return new CommonsFtpsAdapter(type);
            }
        }
        throw new IllegalArgumentException("Unsupported type (" + String.valueOf((Object)type) + ")");
    }
}

