/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.remotefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.jalbum.remotefs.DiskSpaceEvent;
import net.jalbum.remotefs.DiskSpaceListener;
import net.jalbum.remotefs.RemoteFS;
import net.jalbum.remotefs.RemoteFSDelegate;
import net.jalbum.remotefs.RemoteFSException;
import net.jalbum.remotefs.RemoteFSFactory;
import net.jalbum.remotefs.RemoteFSProgressMonitor;
import net.jalbum.remotefs.RemoteFile;
import net.jalbum.remotefs.RemoteFileFilter;
import net.jalbum.remotefs.annotations.AffectsDiskSpace;
import net.jalbum.remotefs.annotations.Concurrent;
import net.jalbum.remotefs.annotations.RecoverFromIOException;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.TransferProtocol;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Stopwatch;

public class RemoteFSBean
implements RemoteFSDelegate {
    private RemoteFS remoteFS = null;
    private TransferProtocol protocol = TransferProtocol.ftp;
    private String currentDirectory = "";
    private String server;
    private String user;
    private String password;
    private boolean trackDiskSpaceUsage;
    private static ScheduledFuture watcherFuture;
    private static final transient List<DiskSpaceListener> diskSpaceListeners;
    public static RemoteFileFilter noDotDotDotFileFilter;
    private boolean aborted;
    private RemoteFSProgressMonitor monitor;

    @Override
    public boolean isTrackDiskSpaceUsage() {
        return this.trackDiskSpaceUsage;
    }

    @Override
    public void setTrackDiskSpaceUsage(boolean trackDiskSpaceUsage) {
        this.trackDiskSpaceUsage = trackDiskSpaceUsage;
    }

    String getServer() {
        return this.server;
    }

    private static synchronized void diskSpaceAffected(RemoteFSBean bean) {
        if (watcherFuture != null) {
            watcherFuture.cancel(false);
        }
        watcherFuture = JAlbumUtilities.schedule(() -> RemoteFSBean.fireDiskSpaceAffected(new DiskSpaceEvent(bean)), 5L, TimeUnit.SECONDS);
    }

    private RemoteFSBean() {
    }

    public static RemoteFSDelegate createInstance() {
        RemoteFSBean target = new RemoteFSBean();
        return (RemoteFSDelegate)Proxy.newProxyInstance(target.getClass().getClassLoader(), target.getClass().getInterfaces(), (InvocationHandler)new RemoteFSHandler(target));
    }

    public TransferProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(TransferProtocol protocol) {
        if (protocol != this.protocol) {
            this.remoteFS = null;
        }
        this.protocol = protocol;
    }

    private RemoteFS getRemoteFS() {
        if (this.remoteFS == null) {
            this.remoteFS = RemoteFSFactory.getRemoteFS(this.protocol);
        }
        return this.remoteFS;
    }

    @Override
    public void testConnection(String server, String user, String password) throws IOException, RemoteFSException {
        this.connect(server, user, password);
        if (!this.isConnected()) {
            throw new RemoteFSException("Not connected to server");
        }
        this.disconnect();
        if (this.isConnected()) {
            throw new RemoteFSException("Still connected to server");
        }
    }

    @Override
    public void setPort(int port) throws RemoteFSException {
        this.getRemoteFS().setPort(port);
    }

    @Override
    public int getPort() throws RemoteFSException {
        return this.getRemoteFS().getPort();
    }

    @Override
    public void setForceUTF8(boolean force) throws RemoteFSException {
        this.getRemoteFS().setForceUTF8(force);
    }

    @Override
    public boolean isForceUTF8() throws RemoteFSException {
        return this.getRemoteFS().isForceUTF8();
    }

    @Override
    public void setPassiveMode(boolean mode) throws RemoteFSException {
        this.getRemoteFS().setPassiveMode(mode);
    }

    @Override
    public boolean isPassiveMode() throws RemoteFSException {
        return this.getRemoteFS().isPassiveMode();
    }

    @Override
    @RecoverFromIOException
    public String getDirectory() throws IOException, RemoteFSException {
        return this.getRemoteFS().getDirectory();
    }

    @Override
    @RecoverFromIOException
    public void setDirectory(String directory) throws IOException, RemoteFSException {
        if (directory.length() == 0) {
            return;
        }
        this.getRemoteFS().setDirectory(directory);
        this.currentDirectory = directory.startsWith("/") ? directory : IO.combinePaths(this.currentDirectory, directory);
    }

    @Override
    @RecoverFromIOException
    public void toParentDirectory() throws RemoteFSException, IOException {
        this.getRemoteFS().toParentDirectory();
        int lastSlashIndex = this.currentDirectory.lastIndexOf(47);
        this.currentDirectory = lastSlashIndex == -1 ? "" : this.currentDirectory.substring(0, lastSlashIndex);
    }

    @Override
    @RecoverFromIOException
    @AffectsDiskSpace
    public void createDirectory(String name) throws IOException, RemoteFSException {
        this.getRemoteFS().createDirectory(name);
    }

    @Override
    @RecoverFromIOException
    @AffectsDiskSpace
    public void removeDirectory(String name) throws IOException, RemoteFSException {
        this.getRemoteFS().removeDirectory(name);
    }

    @Override
    @RecoverFromIOException
    public void connect(String server, String user, String password) throws IOException, RemoteFSException {
        try {
            this.aborted = false;
            this.server = server;
            this.user = user;
            this.password = password;
            this.currentDirectory = "";
            this.getRemoteFS().connect(server, user, password);
        }
        catch (IOException ex) {
            if (this.aborted) {
                throw new InterruptedIOException("Aborted");
            }
            throw ex;
        }
    }

    @Override
    @Concurrent
    public void abortConnect() throws RemoteFSException, IOException {
        this.getRemoteFS().abortConnect();
        this.aborted = true;
    }

    @Override
    public void reconnect() throws RemoteFSException, IOException {
        RemoteFS old = this.getRemoteFS();
        this.remoteFS = null;
        this.remoteFS = this.getRemoteFS();
        this.remoteFS.setForceUTF8(old.isForceUTF8());
        this.remoteFS.setPassiveMode(old.isPassiveMode());
        this.remoteFS.setPort(old.getPort());
        if (this.monitor != null) {
            this.remoteFS.setProgressMonitor(this.monitor);
        }
        this.remoteFS.connect(this.server, this.user, this.password);
        if (!"".equals(this.currentDirectory)) {
            this.remoteFS.setDirectory(this.currentDirectory);
        }
    }

    @Override
    @Concurrent
    public void disconnect() throws IOException, RemoteFSException {
        this.getRemoteFS().disconnect();
    }

    @Override
    @Concurrent
    public boolean isConnected() throws RemoteFSException {
        return this.getRemoteFS().isConnected();
    }

    @Override
    @RecoverFromIOException
    public RemoteFile[] getFiles() throws IOException, RemoteFSException {
        return this.getRemoteFS().getFiles();
    }

    @Override
    @RecoverFromIOException
    public RemoteFile[] getFiles(String dir) throws IOException, RemoteFSException {
        if (dir.length() > 0) {
            return this.getRemoteFS().getFiles(IO.combinePaths(dir, "/"));
        }
        return this.getRemoteFS().getFiles(dir);
    }

    @Override
    @RecoverFromIOException
    public RemoteFile[] getFiles(RemoteFileFilter filter) throws IOException, RemoteFSException {
        return this.getFiles("", filter);
    }

    @Override
    @RecoverFromIOException
    public RemoteFile[] getFiles(String dir, RemoteFileFilter filter) throws IOException, RemoteFSException {
        RemoteFile[] allFiles = this.getFiles(dir);
        return (RemoteFile[])Arrays.asList(allFiles).stream().filter(rf -> filter.accept((RemoteFile)rf)).toArray(RemoteFile[]::new);
    }

    @Override
    @AffectsDiskSpace
    public void putFile(File file) throws IOException, RemoteFSException {
        this.getRemoteFS().putFile(file);
    }

    @Override
    @AffectsDiskSpace
    public void putFile(File file, String path) throws IOException, RemoteFSException {
        try {
            this.getRemoteFS().putFile(file, path);
        }
        catch (RemoteFSException ex) {
            throw new RemoteFSException("Error uploading " + file.getName() + " to " + path + ":", ex);
        }
    }

    @Override
    @AffectsDiskSpace
    public void put(InputStream in, String path) throws IOException, RemoteFSException {
        this.getRemoteFS().put(in, path);
    }

    @Override
    @RecoverFromIOException
    public void get(String path, OutputStream out) throws IOException, RemoteFSException {
        this.getRemoteFS().get(path, out);
    }

    @Override
    @RecoverFromIOException
    public void getUnmonitored(String path, OutputStream out) throws IOException, RemoteFSException {
        this.getRemoteFS().getUnmonitored(path, out);
    }

    @Override
    @RecoverFromIOException
    @AffectsDiskSpace
    public void removeFile(String filename) throws IOException, RemoteFSException {
        this.getRemoteFS().removeFile(filename);
    }

    @Override
    public void setProgressMonitor(RemoteFSProgressMonitor monitor) {
        this.getRemoteFS().setProgressMonitor(monitor);
        this.monitor = monitor;
    }

    @Override
    @RecoverFromIOException
    public void rename(String from, String to) throws IOException, RemoteFSException {
        this.getRemoteFS().rename(from, to);
    }

    @Override
    @RecoverFromIOException
    public boolean exists(String path) throws IOException, RemoteFSException {
        return this.getRemoteFS().exists(path);
    }

    @Override
    @RecoverFromIOException
    public boolean existsDirectory(String path) throws IOException, RemoteFSException {
        return this.getRemoteFS().existsDirectory(path);
    }

    @Override
    public void noop() throws IOException, RemoteFSException {
        this.getRemoteFS().noop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDiskSpaceListener(DiskSpaceListener listener) {
        List<DiskSpaceListener> list = diskSpaceListeners;
        synchronized (list) {
            diskSpaceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDiskSpaceListener(DiskSpaceListener listener) {
        List<DiskSpaceListener> list = diskSpaceListeners;
        synchronized (list) {
            diskSpaceListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireDiskSpaceAffected(DiskSpaceEvent e) {
        List<DiskSpaceListener> list = diskSpaceListeners;
        synchronized (list) {
            for (DiskSpaceListener listener : diskSpaceListeners) {
                listener.diskSpaceAffected(e);
            }
        }
    }

    static {
        diskSpaceListeners = new ArrayList<DiskSpaceListener>();
        noDotDotDotFileFilter = rf -> {
            String name = rf.getName();
            return !name.equals(".") && !name.equals("..");
        };
    }

    static class RemoteFSHandler
    implements InvocationHandler {
        RemoteFSBean bean;
        Stopwatch stopwatch = new Stopwatch("Time between calls");

        public RemoteFSHandler(RemoteFSBean bean) {
            this.bean = bean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            method = this.bean.getClass().getMethod(method.getName(), method.getParameterTypes());
            boolean autoRecover = method.isAnnotationPresent(RecoverFromIOException.class);
            boolean affectsDiskSpace = method.isAnnotationPresent(AffectsDiskSpace.class);
            if (this.bean.trackDiskSpaceUsage && affectsDiskSpace) {
                if (watcherFuture != null) {
                    watcherFuture.cancel(false);
                }
            }
            try {
                if (JAlbum.logger.isLoggable(Level.FINER) && !method.getName().equals("hashCode")) {
                    System.out.print("RemoteFSHandler: " + method.getName() + " ");
                    if (args != null) {
                        boolean first = true;
                        for (Object arg : args) {
                            System.out.print((first ? "" : ", ") + String.valueOf(arg));
                            first = false;
                        }
                    }
                    System.out.println("");
                }
                if (method.isAnnotationPresent(Concurrent.class)) {
                    Object first = method.invoke((Object)this.bean, args);
                    return first;
                }
                RemoteFSHandler first = this;
                synchronized (first) {
                    try {
                        Object object = method.invoke((Object)this.bean, args);
                        return object;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (InvocationTargetException e) {
                            Throwable throwable2 = this.getEmbeddedIOException(e.getTargetException());
                            if (autoRecover && throwable2 instanceof IOException && !(throwable2 instanceof InterruptedIOException)) {
                                this.log("Caught " + String.valueOf(throwable2) + " when calling " + method.getName() + ". Reconnecting");
                                try {
                                    if (this.bean.isConnected()) {
                                        try {
                                            this.bean.disconnect();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                    this.bean.reconnect();
                                    Object object = method.invoke((Object)this.bean, args);
                                    return object;
                                }
                                catch (IOException | RemoteFSException ex) {
                                    throw ex;
                                }
                                catch (InvocationTargetException ex) {
                                    throw ex.getTargetException();
                                }
                            }
                            throw e.getTargetException();
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
                        }
                    }
                }
            }
            finally {
                if (this.bean.trackDiskSpaceUsage && affectsDiskSpace) {
                    RemoteFSBean.diskSpaceAffected(this.bean);
                    this.stopwatch.reset();
                    this.stopwatch.start();
                }
            }
        }

        private Throwable getEmbeddedIOException(Throwable ex) {
            Throwable original = ex;
            do {
                if (!(ex instanceof IOException)) continue;
                return ex;
            } while ((ex = ex.getCause()) != null);
            return original;
        }

        void log(String s) {
            System.out.println("RemoteFSHandler: " + s);
        }

        void debug(String s) {
            Debug.log("RemoteFSHandler: " + s);
        }
    }
}

