/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.projectgroups;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import net.jalbum.projectgroups.FolderProjectGroup;
import net.jalbum.projectgroups.GroupNotEmptyException;
import net.jalbum.projectgroups.PathDatabase;
import net.jalbum.projectgroups.ProjectGroup;
import net.jalbum.projectgroups.VirtualGroup;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;

public class VirtualProjectGroup
extends FolderProjectGroup
implements VirtualGroup {
    static final Icon ICON = Icons.get("project-group-virtual", 20);
    public static final String PROJECTS_FILE_NAME = "jalbum-projects.txt";
    private PathDatabase db;

    public VirtualProjectGroup(Supplier<File> locationSupplier) {
        super(locationSupplier);
        this.init();
    }

    public VirtualProjectGroup(ProjectGroup parent, String name) {
        super(parent, name);
        this.init();
    }

    private File getBackingFile() {
        return new File(this.getLocation(), PROJECTS_FILE_NAME);
    }

    private void init() {
        this.db = new PathDatabase(this.getBackingFile());
    }

    @Override
    public List<AlbumProject> getProjects() {
        if (this.projects == null) {
            this.projects = new ArrayList();
            JAlbumContext context = JAlbumContext.getInstance();
            for (String path : this.db.getPaths()) {
                try {
                    AlbumProject ap = new AlbumProject(new File(path), context.getAlbumObjectfactory());
                    this.projects.add(ap);
                }
                catch (IOException iOException) {}
            }
        }
        return this.projects;
    }

    public void addProject(AlbumProject ap) {
        if (!this.getProjects().contains(ap)) {
            this.db.addPath(ap.getProjectFile().getAbsolutePath());
            this.getProjects().add(ap);
        }
    }

    public void removeProject(AlbumProject ap) {
        this.db.removePath(ap.getProjectFile().getAbsolutePath());
        this.getProjects().remove(ap);
    }

    public void replaceFile(File fromProjectFile, File toProjectFile) {
        for (AlbumProject ap : this.getProjects()) {
            if (!ap.getProjectFile().equals(fromProjectFile)) continue;
            ap.setProjectFile(toProjectFile);
            this.db.removePath(fromProjectFile.getAbsolutePath());
            this.db.addPath(toProjectFile.getAbsolutePath());
        }
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public void createBackingFiles() throws IOException {
        super.createBackingFiles();
        File backingFile = this.getBackingFile();
        if (!backingFile.exists()) {
            backingFile.createNewFile();
        }
    }

    @Override
    public int getSourceActions() {
        return 0x40000000;
    }

    @Override
    public int getDropAction() {
        return 0x40000000;
    }

    @Override
    public void delete() throws GroupNotEmptyException {
        if (!this.getProjects().isEmpty()) {
            throw new GroupNotEmptyException();
        }
        this.getBackingFile().delete();
        super.delete();
    }
}

