/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.projectgroups;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import net.jalbum.projectgroups.PathDatabase;
import net.jalbum.projectgroups.ProjectGroup;
import net.jalbum.projectgroups.RootProjectGroup;
import net.jalbum.projectgroups.VirtualProjectGroup;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.MiniConfig;

public class ProjectGroups {
    public static final String CURRENT_GROUP_PROPERTY = "currentGroup";
    public static final String STRUCTURE_CHANGED_PROPERTY = "structureChanged";
    static PathDatabase locations = new PathDatabase(new File(MiniConfig.getMiniConfig().configDir, "project-groups.txt"));
    private static ProjectGroups instance;
    private static final Preferences prefs;
    private final RootProjectGroup root = new RootProjectGroup();
    private ProjectGroup currentGroup = ProjectGroup.RECENT_PROJECTS_GROUP;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    private ProjectGroups() {
        ProjectGroup group;
        String currentGroupPath = prefs.get(CURRENT_GROUP_PROPERTY, null);
        if (currentGroupPath != null && (group = this.root.getChild(currentGroupPath)) != null) {
            this.currentGroup = group;
        }
    }

    public static ProjectGroups getInstance() {
        if (instance == null) {
            instance = new ProjectGroups();
        }
        return instance;
    }

    public ProjectGroup getRootGroup() {
        return this.root;
    }

    public List<ProjectGroup> getTopGroups() {
        return this.root.getChildren();
    }

    public Stream<ProjectGroup> groups() {
        return new TreeCollection(this.root.getChildren()).stream();
    }

    public ProjectGroup getCurrentGroup() {
        return this.currentGroup;
    }

    public File getNewProjectLocation() {
        ProjectGroup cg = this.getCurrentGroup();
        if (cg == null || cg instanceof VirtualProjectGroup) {
            return new File(Config.getConfig().getMyAlbumsLocation());
        }
        return cg.getLocation();
    }

    public void setCurrentGroup(ProjectGroup group) {
        ProjectGroup oldGroup = this.currentGroup;
        this.currentGroup = group;
        if (this.currentGroup != ProjectGroup.RECENT_PROJECTS_GROUP) {
            prefs.put(CURRENT_GROUP_PROPERTY, group.getPathFromRoot());
        } else {
            prefs.remove(CURRENT_GROUP_PROPERTY);
        }
        this.changeSupport.firePropertyChange(CURRENT_GROUP_PROPERTY, oldGroup, this.currentGroup);
    }

    public static boolean locationExists(File location) {
        return locations.containsPath(location.getAbsolutePath()) && location.exists();
    }

    void groupRenamed(ProjectGroup group, File oldPath, File newPath) {
        locations.removePath(oldPath.getAbsolutePath());
        locations.addPath(newPath.getAbsolutePath());
        this.changeSupport.firePropertyChange(STRUCTURE_CHANGED_PROPERTY, null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(name, listener);
    }

    static {
        prefs = Preferences.userNodeForPackage(ProjectGroups.class);
    }

    private static class TreeCollection
    extends AbstractCollection<ProjectGroup> {
        private Collection<ProjectGroup> objects;

        public TreeCollection(Collection<ProjectGroup> objects) {
            this.objects = objects;
        }

        @Override
        public Iterator<ProjectGroup> iterator() {
            return new TreeIterator(this.objects.iterator());
        }

        @Override
        public int size() {
            int count = 0;
            Iterator<ProjectGroup> it = this.iterator();
            while (it.hasNext()) {
                it.next();
                ++count;
            }
            return count;
        }
    }

    private static class TreeIterator
    implements Iterator<ProjectGroup> {
        private Iterator<ProjectGroup> it;
        private final Deque<Iterator<ProjectGroup>> stack = new ArrayDeque<Iterator<ProjectGroup>>();
        private final Set<ProjectGroup> visited = new HashSet<ProjectGroup>();

        public TreeIterator(Iterator<ProjectGroup> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            if (this.it.hasNext()) {
                return true;
            }
            for (Iterator<ProjectGroup> it2 : this.stack) {
                if (!it2.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public ProjectGroup next() {
            if (this.it.hasNext()) {
                ProjectGroup next = this.it.next();
                if (!this.visited.contains(next)) {
                    this.visited.add(next);
                    if (next.getChildCount() > 0) {
                        this.stack.push(this.it);
                        this.it = next.getChildren().iterator();
                    }
                }
                return next;
            }
            if (!this.stack.isEmpty()) {
                this.it = this.stack.pop();
                return this.next();
            }
            throw new NoSuchElementException();
        }
    }
}

