/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.projectgroups;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.jalbum.projectgroups.FolderProjectGroup;
import net.jalbum.projectgroups.RecentProjectsGroup;
import net.jalbum.projectgroups.VirtualProjectGroup;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Config;

public interface ProjectGroup
extends MutableTreeNode,
Comparable<ProjectGroup> {
    public static final FolderProjectGroup MY_ALBUMS_GROUP = new FolderProjectGroup(() -> new File(Config.getConfig().getMyAlbumsLocation()));
    public static final RecentProjectsGroup RECENT_PROJECTS_GROUP = new RecentProjectsGroup();
    public static final Comparator<AlbumProject> BY_NAME_COMPARATOR = (ap1, ap2) -> ap1.getName().compareToIgnoreCase(ap2.getName());
    public static final Comparator<AlbumProject> BY_REVERSE_NAME_COMPARATOR = (ap1, ap2) -> ap2.getName().compareToIgnoreCase(ap1.getName());
    public static final Comparator<AlbumProject> BY_USE_COMPARATOR = (ap1, ap2) -> (int)(ap2.getLastModified() / 1000L - ap1.getLastModified() / 1000L);
    public static final Comparator<AlbumProject> BY_ADDED_COMPARATOR = (ap1, ap2) -> ap2.getAddedCount() - ap1.getAddedCount();

    public String getName();

    @Override
    default public int compareTo(ProjectGroup o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    default public String getPathFromRoot() {
        if (this.getParent() != null) {
            if (this.getParent().getParent() != null) {
                return ((ProjectGroup)this.getParent()).getPathFromRoot() + "/" + this.getName();
            }
            return this.getName();
        }
        return "";
    }

    public Icon getIcon();

    public String getDescription();

    public File getLocation();

    public List<AlbumProject> getProjects();

    default public Comparator<AlbumProject> getComparator(Config.ProjectOrdering ordering) {
        switch (ordering) {
            case projectsByName: {
                return BY_NAME_COMPARATOR;
            }
            case projectsByReverseName: {
                return BY_REVERSE_NAME_COMPARATOR;
            }
        }
        return BY_USE_COMPARATOR;
    }

    default public List<AlbumProject> sort(List<AlbumProject> projects, Config.ProjectOrdering ordering) {
        Collections.sort(projects, this.getComparator(ordering));
        return projects;
    }

    public ProjectGroup getParentGroup();

    public void setParentGroup(ProjectGroup var1);

    public List<ProjectGroup> getChildren();

    default public ProjectGroup getChild(String path) {
        int slashIndex = path.indexOf(47);
        if (slashIndex >= 0) {
            ProjectGroup child = this.getChild(path.substring(0, slashIndex));
            if (child != null) {
                return child.getChild(path.substring(slashIndex + 1));
            }
        } else {
            for (ProjectGroup child : this.getChildren()) {
                if (!child.getName().equals(path)) continue;
                return child;
            }
        }
        return null;
    }

    private void getTreePath(List nodes) {
        nodes.add(0, this);
        if (this.getParentGroup() != null) {
            this.getParentGroup().getTreePath(nodes);
        }
    }

    default public TreePath getTreePath() {
        ArrayList list = new ArrayList();
        this.getTreePath(list);
        return new TreePath(list.toArray());
    }

    default public Enumeration<TreeNode> children() {
        final Iterator<ProjectGroup> it = this.getChildren().iterator();
        return new Enumeration<TreeNode>(){
            final /* synthetic */ ProjectGroup this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public TreeNode nextElement() {
                return (TreeNode)it.next();
            }
        };
    }

    @Override
    default public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    default public TreeNode getChildAt(int childIndex) {
        return this.getChildren().get(childIndex);
    }

    @Override
    default public TreeNode getParent() {
        return this.getParentGroup();
    }

    @Override
    default public int getIndex(TreeNode node) {
        return this.getChildren().indexOf(node);
    }

    @Override
    default public boolean getAllowsChildren() {
        return true;
    }

    @Override
    default public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    default public void insert(MutableTreeNode child, int index) {
        child.removeFromParent();
        child.setParent(this);
        this.getChildren().add(index, (ProjectGroup)child);
    }

    @Override
    default public void remove(int index) {
        this.getChildren().remove(index);
    }

    @Override
    default public void remove(MutableTreeNode node) {
        this.getChildren().remove((ProjectGroup)node);
    }

    @Override
    default public void setUserObject(Object object) {
    }

    @Override
    default public void removeFromParent() {
        if (this.getParent() != null) {
            ((MutableTreeNode)this.getParent()).remove(this);
        }
    }

    @Override
    default public void setParent(MutableTreeNode newParent) {
        this.setParentGroup((ProjectGroup)newParent);
    }

    public static ProjectGroup createInstance(Supplier<File> locationSupplier) {
        File db = new File(locationSupplier.get(), "jalbum-projects.txt");
        return db.exists() ? new VirtualProjectGroup(locationSupplier) : new FolderProjectGroup(locationSupplier);
    }

    public static ProjectGroup createInstance(FolderProjectGroup parent, String name) {
        File loc = FolderProjectGroup.locationFor(parent, name);
        File db = new File(loc, "jalbum-projects.txt");
        return db.exists() ? new VirtualProjectGroup(parent, name) : new FolderProjectGroup(parent, name);
    }

    default public void createBackingFiles() throws IOException {
    }

    public int getSourceActions();

    public int getDropAction();
}

