/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.metadata.exif;

import com.drew.lang.GeoLocation;
import com.drew.lang.Rational;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.GpsDescriptor;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.xmp.XmpDirectory;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import se.datadosen.jalbum.XmpManager;

public class ExtendedGpsDescriptor
extends GpsDescriptor {
    private static DecimalFormatSymbols usDecimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
    private final DecimalFormat decimalFormat = new DecimalFormat("0.00", usDecimalFormatSymbols);

    public ExtendedGpsDescriptor(GpsDirectory directory) {
        super(directory);
        this.decimalFormat.setDecimalSeparatorAlwaysShown(false);
        this.decimalFormat.setMaximumFractionDigits(5);
    }

    private String getGpsLocationDescription(int tagType, int refTag) throws MetadataException {
        Rational[] r = ((GpsDirectory)this._directory).getRationalArray(tagType);
        Rational degs = r[0];
        Rational mins = r[1];
        Rational secs = r[2];
        double loc = degs.doubleValue() + mins.doubleValue() / 60.0 + secs.doubleValue() / 3600.0;
        String ref = ((GpsDirectory)this._directory).getString(refTag);
        if ("W".equals(ref) || "S".equals(ref)) {
            loc = -loc;
        }
        return this.decimalFormat.format(loc);
    }

    public String getGpsLocationDescription() throws MetadataException {
        if (!(((GpsDirectory)this._directory).containsTag(2) && ((GpsDirectory)this._directory).containsTag(1) && ((GpsDirectory)this._directory).containsTag(4) && ((GpsDirectory)this._directory).containsTag(3))) {
            return null;
        }
        return this.getGpsLocationDescription(2, 1) + "," + this.getGpsLocationDescription(4, 3);
    }

    private static String[] numberSplit(String s) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (Character.isDigit(c) || c == '.' || c == '-') {
                token.append(c);
                continue;
            }
            if (token.length() <= 0) continue;
            tokens.add(token.toString());
            token = new StringBuilder();
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static double formatDouble(String coord) {
        char rel;
        String[] tokens = ExtendedGpsDescriptor.numberSplit(coord);
        double loc = 0.0;
        loc = tokens.length == 1 ? Double.parseDouble(tokens[0]) : (double)Integer.parseInt(tokens[0]) + Double.parseDouble(tokens[1]) / 60.0;
        if (tokens.length == 3) {
            loc += Double.parseDouble(tokens[2]) / 3600.0;
        }
        if ((rel = coord.charAt(coord.length() - 1)) == 'S' || rel == 'W') {
            loc = -loc;
        }
        return loc;
    }

    public static void addGpsVariables(XmpDirectory dir, Map<String, Object> variables) {
        Map props = dir.getXmpProperties();
        String gpsLat = (String)props.get("exif:GPSLatitude");
        String gpsLong = (String)props.get("exif:GPSLongitude");
        if (gpsLat != null && gpsLong != null) {
            double dLat = ExtendedGpsDescriptor.formatDouble(gpsLat);
            double dLong = ExtendedGpsDescriptor.formatDouble(gpsLong);
            variables.put("gpsLocation", XmpManager.toGpsLocation(dLat, dLong));
            variables.put("gpsLatitude", GeoLocation.decimalToDegreesMinutesSecondsString((double)dLat));
            variables.put("gpsLongitude", GeoLocation.decimalToDegreesMinutesSecondsString((double)dLong));
        }
    }
}

