/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.metadata.exif;

import com.drew.metadata.Directory;
import com.drew.metadata.exif.ExifDescriptorBase;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class ExtendedExifDescriptor
extends ExifDescriptorBase {
    private static final int ENCODING_REGION_LENGTH = 8;

    public ExtendedExifDescriptor(Directory directory) {
        super(directory);
    }

    public String getUserCommentDescription() {
        if (!this._directory.containsTag(37510)) {
            return null;
        }
        byte[] commentBytes = this._directory.getByteArray(37510);
        if (commentBytes == null || commentBytes.length == 0) {
            return "";
        }
        HashMap<String, String> encmap = new HashMap<String, String>();
        encmap.put("ASCII", System.getProperty("jalbum.file.encoding"));
        encmap.put("UNICODE", "UTF-16LE");
        encmap.put("JIS", "Shift-JIS");
        try {
            if (commentBytes.length >= 8) {
                String encodingRegion = new String(commentBytes, 0, 8);
                for (String encodingName : encmap.keySet()) {
                    if (!encodingRegion.startsWith(encodingName)) continue;
                    String destEncoding = (String)encmap.get(encodingName);
                    if (destEncoding == null) {
                        destEncoding = System.getProperty("jalbum.file.encoding");
                    }
                    for (int j = encodingName.length(); j < 8; ++j) {
                        byte b = commentBytes[j];
                        if (b == 0 || b == 32) continue;
                        return ExtendedExifDescriptor.decodeString(commentBytes, j, commentBytes.length - j, destEncoding).trim();
                    }
                    return ExtendedExifDescriptor.decodeString(commentBytes, 8, commentBytes.length - 8, destEncoding).trim();
                }
            }
            return new String(commentBytes, System.getProperty("jalbum.file.encoding")).trim();
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    private static String decodeString(byte[] bytes, int offset, int length, String suggestedEncoding) throws UnsupportedEncodingException {
        if (suggestedEncoding.startsWith("UTF-16")) {
            int beCounter = 0;
            int leCounter = 0;
            for (int i = offset; i < offset + length; i += 2) {
                if (bytes[i] == 0) {
                    ++beCounter;
                }
                if (bytes[i + 1] != 0) continue;
                ++leCounter;
            }
            suggestedEncoding = beCounter > leCounter ? "UTF-16BE" : "UTF-16LE";
        }
        return new String(bytes, offset, length, suggestedEncoding);
    }
}

