/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.imaging;

import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMetaFactory;
import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.xmp.XmpDirectory;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import net.jalbum.avif.AVIFMetadata;
import net.jalbum.avif.SafeAvif;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.util.FileFilters;

public class ImageMetadataReader2 {
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws ImageProcessingException, IOException {
        if (FileFilters.isAVIFImage(file) && SafeAvif.isInitiatedOk()) {
            Metadata md;
            block5: {
                AVIFMetadata meta = (AVIFMetadata)FileFilters.getMetaData(file);
                md = new Metadata();
                if (meta.getEXIF() != null) {
                    ByteArrayReader reader = new ByteArrayReader(meta.getEXIF());
                    new ExifReader().extract((RandomAccessReader)reader, md, 0);
                }
                if (meta.getXmp() != null) {
                    XmpDirectory xmpDir = new XmpDirectory();
                    try {
                        xmpDir.setXMPMeta(XMPMetaFactory.parseFromBuffer((byte[])meta.getXmp()));
                        md.addDirectory((Directory)xmpDir);
                    }
                    catch (XMPException ex) {
                        if (!JAlbum.logger.isLoggable(Level.FINE)) break block5;
                        System.err.println("Error parsing xmp data from file " + String.valueOf(file) + ": " + String.valueOf((Object)ex));
                    }
                }
            }
            return md;
        }
        return ImageMetadataReader.readMetadata((File)file);
    }
}

