/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters.auto;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.jalbum.filters.AbstractFilter;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.StateMonitor;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.GraphicsUtilities;
import se.datadosen.util.annotations.Unbound;

public class AutoFilter
extends AbstractFilter {
    private final int AUTO_COLOR_VALUE = 20;
    private int[] pixels;
    private int[] lumPixels;
    private int[] redPixels;
    private int[] greenPixels;
    private int[] bluePixels;
    private int[] largestOccs;
    private final double clipping = 0.001;
    private boolean contrast = false;
    private boolean levels = false;
    private boolean colors = false;
    private boolean colorsPossible = false;
    private UI myUI;

    private void initArrays() {
        this.lumPixels = new int[256];
        this.redPixels = new int[256];
        this.greenPixels = new int[256];
        this.bluePixels = new int[256];
        this.largestOccs = new int[3];
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AutoFilter cloned = (AutoFilter)super.clone();
        cloned.initArrays();
        return cloned;
    }

    public AutoFilter() {
        this.initArrays();
    }

    public AutoFilter(boolean contrast, boolean colors, boolean levels) {
        this.initArrays();
        this.contrast = contrast;
        this.colors = colors;
        this.levels = levels;
    }

    public AutoFilter(boolean enhanceAll) {
        this(enhanceAll, enhanceAll, enhanceAll);
    }

    @Override
    public String getName() {
        return Msg.getString(this, "filters.auto.shortName");
    }

    @Override
    public ImageIcon getIcon() {
        return (ImageIcon)Icons.small("auto");
    }

    @Override
    public String getDescription() {
        return Msg.getString(this, "filters.auto.description");
    }

    @Override
    @Unbound
    public boolean isEnabled() {
        return this.colors || this.contrast || this.levels;
    }

    @Override
    public BufferedImage filter(BufferedImage bi, Map map) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        this.pixels = new int[width * height];
        bi.getRGB(0, 0, width, height, this.pixels, 0, width);
        BufferedImage dstBi = GraphicsUtilities.createEmptyImage(bi);
        if (this.colors) {
            this.autoColor();
        }
        if (this.contrast) {
            this.autoContrast();
        }
        if (this.levels) {
            this.autoLevels();
        }
        dstBi.setRGB(0, 0, width, height, this.pixels, 0, width);
        this.pixels = null;
        return dstBi;
    }

    public boolean isContrast() {
        return this.contrast;
    }

    public void setContrast(boolean contrast) {
        boolean oldIsEnabled = this.isEnabled();
        boolean oldContrast = this.contrast;
        this.contrast = contrast;
        this.changeSupport.firePropertyChange("contrast", oldContrast, contrast);
        this.changeSupport.firePropertyChange("enabled", oldIsEnabled, this.isEnabled());
    }

    public boolean isLevels() {
        return this.levels;
    }

    public void setLevels(boolean levels) {
        boolean oldIsEnabled = this.isEnabled();
        boolean oldLevels = this.levels;
        this.levels = levels;
        this.changeSupport.firePropertyChange("levels", oldLevels, levels);
        this.changeSupport.firePropertyChange("enabled", oldIsEnabled, this.isEnabled());
    }

    public boolean isColors() {
        return this.colors;
    }

    public void setColors(boolean colors) {
        boolean oldIsEnabled = this.isEnabled();
        boolean oldColors = this.colors;
        this.colors = colors;
        this.changeSupport.firePropertyChange("colors", oldColors, colors);
        this.changeSupport.firePropertyChange("enabled", oldIsEnabled, this.isEnabled());
    }

    @Unbound
    public boolean isColorsPossible() {
        return this.colorsPossible;
    }

    private void autoContrast() {
        this.createLuminanceArray();
        int clipNum = this.round((double)this.pixels.length * 0.001);
        int max = this.getMaximum(clipNum, this.lumPixels);
        int min = this.getMinimum(clipNum, this.lumPixels);
        double contrast = 255.0 / (double)(max - min);
        double brightness = 127.5 - (double)(max + min) / 2.0;
        this.changeContrastBrightness(contrast, brightness);
    }

    private int getMaximum(int clipNum, int[] arr) {
        int max = 0;
        int i = 255;
        while (max < clipNum) {
            max += arr[i];
            --i;
        }
        max = ++i;
        return max;
    }

    private int getMinimum(int clipNum, int[] arr) {
        int min = 0;
        int i = 0;
        while (min < clipNum) {
            min += arr[i];
            ++i;
        }
        min = --i;
        return min;
    }

    private void changeContrastBrightness(double contrast, double brightness) {
        for (int i = 0; i < this.pixels.length; ++i) {
            int argb = this.pixels[i];
            int a = argb >> 24 & 0xFF;
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            double Y = 0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b;
            double Cb = -0.168736 * (double)r - 0.331264 * (double)g + 0.5 * (double)b;
            double Cr = 0.5 * (double)r - 0.418688 * (double)g - 0.081312 * (double)b;
            Y = contrast * (Y + brightness - 127.5) + 127.5;
            int rn = (int)(Y + 1.402 * Cr + 0.5);
            int gn = (int)(Y - 0.3441 * Cb - 0.7141 * Cr + 0.5);
            int bn = (int)(Y + 1.772 * Cb + 0.5);
            int[] clipped = this.clipping(rn, gn, bn);
            this.pixels[i] = a << 24 | clipped[0] << 16 | clipped[1] << 8 | clipped[2];
        }
    }

    private void autoLevels() {
        this.createRedArray();
        this.createGreenArray();
        this.createBlueArray();
        int clipNum = this.round((double)this.pixels.length * 0.001);
        double[] factors = new double[6];
        int max = this.getMaximum(clipNum, this.redPixels);
        int min = this.getMinimum(clipNum, this.redPixels);
        factors[0] = 255.0 / (double)(max - min);
        factors[1] = 127.5 - (double)(max + min) / 2.0;
        max = this.getMaximum(clipNum, this.greenPixels);
        min = this.getMinimum(clipNum, this.greenPixels);
        factors[2] = 255.0 / (double)(max - min);
        factors[3] = 127.5 - (double)(max + min) / 2.0;
        max = this.getMaximum(clipNum, this.bluePixels);
        min = this.getMinimum(clipNum, this.bluePixels);
        factors[4] = 255.0 / (double)(max - min);
        factors[5] = 127.5 - (double)(max + min) / 2.0;
        this.changeLevels(factors);
    }

    private void changeLevels(double[] factors) {
        for (int i = 0; i < this.pixels.length; ++i) {
            int argb = this.pixels[i];
            int a = argb >> 24 & 0xFF;
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            int rn = (int)(factors[0] * ((double)r + factors[1] - 127.5) + 127.5);
            int gn = (int)(factors[2] * ((double)g + factors[3] - 127.5) + 127.5);
            int bn = (int)(factors[4] * ((double)b + factors[5] - 127.5) + 127.5);
            int[] clipped = this.clipping(rn, gn, bn);
            this.pixels[i] = a << 24 | clipped[0] << 16 | clipped[1] << 8 | clipped[2];
        }
    }

    private void autoColor() {
        this.createRedArray();
        this.createGreenArray();
        this.createBlueArray();
        int[] minIndices = new int[3];
        Arrays.fill(minIndices, 0);
        this.colorsPossible = false;
        if (this.largestOccs[0] > 235) {
            minIndices[0] = this.getMinIndex(this.redPixels);
            this.colorsPossible = true;
        }
        if (this.largestOccs[1] > 235) {
            minIndices[1] = this.getMinIndex(this.greenPixels);
            this.colorsPossible = true;
        }
        if (this.largestOccs[2] > 235) {
            minIndices[2] = this.getMinIndex(this.bluePixels);
            this.colorsPossible = true;
        }
        if (this.isColorsPossible()) {
            for (int i = 0; i < this.pixels.length; ++i) {
                int argb = this.pixels[i];
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                int[] clipped = this.clipping(r -= minIndices[0], g -= minIndices[1], b -= minIndices[2]);
                this.pixels[i] = a << 24 | clipped[0] << 16 | clipped[1] << 8 | clipped[2];
            }
        }
    }

    private int getMinIndex(int[] arr) {
        int min = 0;
        int i = -1;
        while (min == 0) {
            min = arr[++i];
        }
        if (i > 20) {
            i = 20;
        }
        return i;
    }

    private int[] clipping(int r, int g, int b) {
        if (r > 255) {
            r = 255;
        } else if (r < 0) {
            r = 0;
        }
        if (g > 255) {
            g = 255;
        } else if (g < 0) {
            g = 0;
        }
        if (b > 255) {
            b = 255;
        } else if (b < 0) {
            b = 0;
        }
        int[] clipped = new int[]{r, g, b};
        return clipped;
    }

    private void createLuminanceArray() {
        Arrays.fill(this.lumPixels, 0);
        for (int i = 0; i < this.pixels.length; ++i) {
            int lumR;
            int rgb = this.pixels[i];
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            double lum = 0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b;
            int n = lumR = this.round(lum);
            this.lumPixels[n] = this.lumPixels[n] + 1;
        }
    }

    private void createRedArray() {
        Arrays.fill(this.redPixels, 0);
        int largestOcc = 0;
        int index = 0;
        for (int i = 0; i < this.pixels.length; ++i) {
            int r;
            int rgb = this.pixels[i];
            int n = r = rgb >> 16 & 0xFF;
            this.redPixels[n] = this.redPixels[n] + 1;
            if (this.redPixels[r] <= largestOcc) continue;
            largestOcc = this.redPixels[r];
            index = r;
        }
        this.largestOccs[0] = index;
    }

    private void createGreenArray() {
        Arrays.fill(this.greenPixels, 0);
        int largestOcc = 0;
        int index = 0;
        for (int i = 0; i < this.pixels.length; ++i) {
            int g;
            int rgb = this.pixels[i];
            int n = g = rgb >> 8 & 0xFF;
            this.greenPixels[n] = this.greenPixels[n] + 1;
            if (this.greenPixels[g] <= largestOcc) continue;
            largestOcc = this.greenPixels[g];
            index = g;
        }
        this.largestOccs[1] = index;
    }

    private void createBlueArray() {
        Arrays.fill(this.bluePixels, 0);
        int largestOcc = 0;
        int index = 0;
        for (int i = 0; i < this.pixels.length; ++i) {
            int b;
            int rgb = this.pixels[i];
            int n = b = rgb & 0xFF;
            this.bluePixels[n] = this.bluePixels[n] + 1;
            if (this.bluePixels[b] <= largestOcc) continue;
            largestOcc = this.bluePixels[b];
            index = b;
        }
        this.largestOccs[2] = index;
    }

    private int round(double lum) {
        int r = lum >= 0.0 ? (int)(lum + 0.5) : (int)(lum - 0.5);
        return r;
    }

    @Override
    public JComponent userInterface() {
        if (this.myUI == null) {
            this.myUI = new UI();
        }
        return this.myUI;
    }

    private class UI
    extends ControlPanel {
        private final JCheckBox enhanceAll = new JCheckBox(Msg.getString(this, "filters.auto.controls.ownsettings"));
        public final JCheckBox contrast = new JCheckBox(Msg.getString(this, "filters.auto.controls.contrast"));
        public final JCheckBox levels = new JCheckBox(Msg.getString(this, "filters.auto.controls.levels"));
        public final JCheckBox colors = new JCheckBox(Msg.getString(this, "filters.auto.controls.colors"));

        public UI() {
            this.init();
        }

        private void init() {
            this.contrast.setToolTipText(Msg.getString(this, "filters.auto.controls.contrast.tooltip"));
            this.contrast.setEnabled(false);
            this.levels.setToolTipText(Msg.getString(this, "filters.auto.controls.levels.tooltip"));
            this.levels.setEnabled(false);
            this.colors.setToolTipText(Msg.getString(this, "filters.auto.controls.colors.tooltip"));
            this.colors.setEnabled(false);
            this.enhanceAll.setToolTipText(Msg.getString(this, "filters.auto.controls.ownsettings.tooltip"));
            StateMonitor.monitoring(this.enhanceAll).onChange(c -> {
                boolean b = this.enhanceAll.isSelected();
                this.contrast.setSelected(b);
                this.levels.setSelected(b);
                this.colors.setSelected(b);
                this.contrast.setEnabled(!b);
                this.levels.setEnabled(!b);
                this.colors.setEnabled(!b);
                this.colors.setToolTipText(Msg.getString(this, "filters.auto.controls.colors.tooltip"));
                if (!AutoFilter.this.isColorsPossible() && !b) {
                    this.colors.setEnabled(false);
                    this.colors.setToolTipText(Msg.getString(this, "filters.auto.controls.tooltip.false"));
                }
            });
            JPanel controlPanel = new JPanel(new RiverLayout());
            controlPanel.add(this.colors);
            controlPanel.add("br", this.contrast);
            controlPanel.add("br ", this.levels);
            this.add("br", this.enhanceAll);
            this.add("br", controlPanel);
            BeanBinder.getProperties((Object)AutoFilter.this, this);
            StateMonitor.monitoring(this.contrast, this.levels, this.colors).onUserChange(c -> BeanBinder.setProperties((Object)AutoFilter.this, this));
        }
    }
}

