/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters.arty.effects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Map;
import net.jalbum.filters.arty.effects.ArtySupport;
import net.jalbum.filters.arty.effects.BlendComposite;

public class SunflowerFilter
extends ArtySupport {
    @Override
    public String getName() {
        return "Sunflower";
    }

    @Override
    public String getDescription() {
        return "effect like the Brannin filter in Instagram";
    }

    @Override
    public BufferedImage filter(BufferedImage bi, Map map) {
        return this.filter(bi);
    }

    @Override
    public BufferedImage filter(BufferedImage bi) {
        BufferedImage temp = SunflowerFilter.convertType(bi, 2);
        BufferedImage tmp = this.getGrayScale(temp);
        int[] pixels = this.getPixels(temp);
        pixels = this.applySaturation(pixels, -0.3f);
        bi = this.setPixels(temp, pixels);
        Graphics2D g2 = temp.createGraphics();
        g2.drawImage((Image)temp, 0, 0, null);
        g2.setComposite(BlendComposite.getInstance(BlendComposite.BlendingMode.OVERLAY, 0.7f));
        g2.drawImage(tmp, 0, 0, temp.getWidth(), temp.getHeight(), null);
        BufferedImage dstImg = this.applyBrightnessAndContrast(temp, -5.0, 10.0);
        pixels = this.getPixels(dstImg);
        pixels = this.applySaturation(pixels, 0.35f);
        dstImg = this.setPixels(dstImg, pixels);
        BufferedImage tmp2 = new BufferedImage(temp.getWidth(), temp.getHeight(), temp.getType());
        g2 = tmp2.createGraphics();
        g2.setColor(new Color(220, 210, 170));
        g2.fill(new Rectangle(0, 0, temp.getWidth(), temp.getHeight()));
        Graphics2D g = dstImg.createGraphics();
        g.drawImage((Image)dstImg, 0, 0, null);
        g.setComposite(BlendComposite.getInstance(BlendComposite.BlendingMode.OVERLAY, 0.3f));
        g.drawImage(tmp2, 0, 0, temp.getWidth(), temp.getHeight(), null);
        return SunflowerFilter.convertType(dstImg, bi.getType());
    }
}

