/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters.arty;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import net.jalbum.filters.arty.ArtyFilter;
import net.jalbum.filters.arty.Effect;
import net.jalbum.filters.arty.effects.ArtySupport;
import se.datadosen.component.MarginIcon;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.util.PersistentList;

public class JArtySelector
extends JPanel
implements PersistentList {
    private ArtyFilter filter;
    private final Color highColor = JAlbumColor.textHighlight;
    private BufferedImage image;
    private final ButtonGroup group = new ButtonGroup();
    private JPanel content = new JPanel();

    JArtySelector(ArtyFilter filter) {
        try {
            this.filter = filter;
            this.image = ImageIO.read(JArtySelector.class.getResource("res/sample.jpg"));
            if (this.image.getType() != 2 || this.image.getType() == 1) {
                this.image = ArtySupport.convertType(this.image, 2);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.initComponents();
    }

    public JArtySelector(BufferedImage bi) {
        this.image = bi;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new FlowLayout(1));
        this.content.setLayout(new GridLayout(3, 4, 0, 0));
        ActionListener buttonListener = e -> {
            JRadioButton source = (JRadioButton)e.getSource();
            this.filter.setEffect(Effect.valueOf(source.getName()));
        };
        Insets insets = new Insets(2, 2, 2, 2);
        for (Effect f : Effect.values()) {
            BufferedImage temp = ArtySupport.convertType(this.image, 2);
            JBasicRadioButton btn = new JBasicRadioButton();
            if (f != Effect.none) {
                JAFilter effectFilter = f.getFilter();
                temp = effectFilter.filter(this.image, null);
                if (f.hasBorder()) {
                    temp = ArtySupport.adjustBorder(temp);
                }
            } else {
                btn.setSelected(true);
            }
            btn.setName(f.name());
            btn.setToolTipText(f.toString() + ": " + f.getToolTip());
            btn.setBorder(BorderFactory.createEmptyBorder());
            btn.addActionListener(buttonListener);
            this.group.add(btn);
            this.content.add(btn);
            this.add(this.content);
            temp = ArtySupport.convertType(temp, this.image.getType());
            btn.setIcon(new MarginIcon(insets, (Icon)new ImageIcon(temp)));
            if (f == Effect.none) {
                btn.setIcon(this.getHighligthedIcon(btn, Color.DARK_GRAY));
            }
            btn.setSelectedIcon(this.getHighligthedIcon(btn, this.highColor));
            this.filter.addPropertyChangeListener("effect", evt -> this.setEffect((Effect)((Object)((Object)evt.getNewValue()))));
            this.setEffect(this.filter.getEffect());
        }
    }

    private Icon getHighligthedIcon(JRadioButton button, Color borderColor) {
        Icon icon = button.getIcon();
        BufferedImage bi = JAlbumContext.getInstance().getFrame().getGraphicsConfiguration().createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), 3);
        Graphics2D g = bi.createGraphics();
        icon.paintIcon(button, g, 0, 0);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(borderColor);
        g.setStroke(new BasicStroke(4.0f));
        g.drawRect(2, 2, bi.getWidth() - 5, bi.getHeight() - 5);
        g.dispose();
        return new ImageIcon(bi);
    }

    public Effect getEffect() {
        return this.filter.getEffect();
    }

    public void setEffect(Effect effect) {
        for (Component comp : this.content.getComponents()) {
            if (!comp.getName().equals(effect.name())) continue;
            ((JRadioButton)comp).setSelected(true);
            this.filter.setEffect(effect);
            break;
        }
    }

    @Override
    public List<String> getContent() {
        ArrayList<String> theList = new ArrayList<String>();
        theList.add(this.getEffect().name());
        return theList;
    }

    @Override
    public void setContent(List<String> list) {
        String effect = list.get(0);
        if (effect == null || effect.isEmpty()) {
            this.setEffect(null);
        } else {
            try {
                this.setEffect(Effect.valueOf(list.get(0)));
            }
            catch (Exception ex) {
                System.err.println("ArtySelector ignoring illegal effect: " + ex.toString());
            }
        }
    }

    private static class JBasicRadioButton
    extends JRadioButton {
        private JBasicRadioButton() {
        }

        @Override
        public void updateUI() {
            this.setUI(BasicRadioButtonUI.createUI(this));
        }
    }
}

