/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Map;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.jalbum.ModifiesSize;

public class CropFilter
implements JAFilter,
ModifiesSize {
    private Dimension bounds = new Dimension(120, 120);
    private float xWeight = 0.5f;
    private float yWeight = 0.2f;

    @Override
    public String getName() {
        return "Crop filter";
    }

    @Override
    public String getDescription() {
        return "Crops images to specified dimension";
    }

    public Dimension getBounds() {
        return this.bounds;
    }

    public void setBounds(Dimension bounds) {
        this.bounds = bounds;
    }

    public float getXWeight() {
        return this.xWeight;
    }

    public void setXWeight(float weight) {
        this.xWeight = weight;
    }

    public float getYWeight() {
        return this.yWeight;
    }

    public void setYWeight(float weight) {
        this.yWeight = weight;
    }

    private Dimension minDimension(Dimension d1, Dimension d2) {
        return new Dimension(Math.min(d1.width, d2.width), Math.min(d1.height, d2.height));
    }

    @Override
    public BufferedImage filter(BufferedImage bi, Map vars) {
        Dimension sDim = new Dimension(bi.getWidth(), bi.getHeight());
        Dimension dDim = this.minDimension(sDim, this.bounds);
        float hw = this.xWeight;
        float vw = this.yWeight;
        if (vars != null) {
            if (vars.containsKey("xWeight")) {
                hw = Float.parseFloat((String)vars.get("xWeight"));
            }
            if (vars.containsKey("yWeight")) {
                vw = Float.parseFloat((String)vars.get("yWeight"));
            }
        }
        return bi.getSubimage((int)((float)(sDim.width - dDim.width) * hw), (int)((float)(sDim.height - dDim.height) * vw), dDim.width, dDim.height);
    }

    @Override
    public Dimension getModifiedSize(Dimension originalSize, Map vars) {
        return this.minDimension(originalSize, this.bounds);
    }
}

