/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import net.jalbum.component.JImageComponent;
import net.jalbum.component.JZoomScrollPane;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Icons;
import se.datadosen.util.GraphicsUtilities;

public class JZoomControlPanel
extends JPanel {
    private static final Dimension PREFERRED_SIZE = new Dimension(120, 100);
    private static final int CORNER_RADIUS = 10;
    private final JZoomScrollPane scrollPane;
    private final JImagePanControl panControl = new JImagePanControl();
    private final JSlider zoomSlider = new JSlider(0, 100, 0);
    private final JButton zoomMin = new JPlainButton(Icons.small("contract"));
    private final JButton zoomMax = new JPlainButton(Icons.small("1to1"));

    public JZoomControlPanel(JZoomScrollPane scrollPane) {
        this.scrollPane = scrollPane;
        this.init();
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        super.paintComponent(g2d);
        Graphics2D g = (Graphics2D)g2d.create();
        g.setColor(this.getBackground());
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fillRoundRect(0, 0, this.getWidth() - 8, this.getHeight() - 8, 10, 10);
        g.dispose();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 18, 18));
        this.setOpaque(false);
        this.setBackground(new Color(64, 64, 64, 127));
        this.zoomMin.setFocusable(false);
        this.zoomMax.setFocusable(false);
        this.zoomMin.setPreferredSize(new Dimension(18, 18));
        this.zoomMax.setPreferredSize(new Dimension(18, 18));
        Dimension pref = this.zoomSlider.getPreferredSize();
        pref.width = 100;
        this.zoomSlider.setPreferredSize(pref);
        this.zoomSlider.setOpaque(false);
        JPanel buttonPanel = new JPanel(new RiverLayout(0, 0));
        buttonPanel.setOpaque(false);
        buttonPanel.add(this.zoomMin);
        buttonPanel.add(Box.createHorizontalStrut(4));
        buttonPanel.add("hfill", this.zoomSlider);
        buttonPanel.add(Box.createHorizontalStrut(4));
        buttonPanel.add(this.zoomMax);
        this.add((Component)buttonPanel, "Last");
        this.add((Component)this.panControl, "Center");
        this.panControl.setVisible(false);
        JImageComponent imageComp = this.scrollPane.getImageComponent();
        this.scrollPane.getViewport().addChangeListener(ce -> this.updateVisuals());
        imageComp.addPropertyChangeListener(pce -> this.updateVisuals());
        imageComp.addPropertyChangeListener("zoomLevel", pce -> {
            if (!this.zoomSlider.getValueIsAdjusting()) {
                this.zoomSlider.setValue((int)(100.0 * (Double)pce.getNewValue()));
            }
        });
        this.zoomSlider.addChangeListener(ce -> {
            if (this.zoomSlider.getValueIsAdjusting()) {
                this.scrollPane.setZoomLevel((double)this.zoomSlider.getValue() / 100.0);
            }
        });
        imageComp.addPropertyChangeListener("image", pce -> {
            this.panControl.cachedThumb = null;
            this.updateVisuals();
        });
        this.zoomMin.addActionListener(ae -> this.scrollPane.setZoomLevel(0.0));
        this.zoomMax.addActionListener(ae -> this.scrollPane.setZoomLevel(1.0));
    }

    private void updateVisuals() {
        JImageComponent imageComp = this.scrollPane.getImageComponent();
        this.setVisible(imageComp.isZoomeable());
        this.panControl.setVisible(imageComp.getZoomLevel() > 0.01);
        this.panControl.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private static Rectangle scaleRect(Rectangle r1, float s) {
        return new Rectangle(Math.round((float)r1.x * s), Math.round((float)r1.y * s), Math.round((float)r1.width * s), Math.round((float)r1.height * s));
    }

    private class JImagePanControl
    extends JComponent {
        private BufferedImage cachedThumb;

        public JImagePanControl() {
            this.setPreferredSize(PREFERRED_SIZE);
            MouseAdapter listener = new MouseAdapter(){
                private Point plantPoint;

                @Override
                public void mousePressed(MouseEvent e) {
                    Rectangle ib = JImagePanControl.this.getImageBounds();
                    Point checkPoint = new Point(e.getPoint().x - ib.x, e.getPoint().y - ib.y);
                    if (JImagePanControl.this.getViewportBounds().contains(checkPoint)) {
                        JImagePanControl.this.setCursor(Cursor.getPredefinedCursor(12));
                        this.plantPoint = e.getPoint();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    JImagePanControl.this.setCursor(Cursor.getDefaultCursor());
                    this.plantPoint = null;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (this.plantPoint != null) {
                        int dx = e.getPoint().x - this.plantPoint.x;
                        int dy = e.getPoint().y - this.plantPoint.y;
                        Point viewPos = JZoomControlPanel.this.scrollPane.getViewport().getViewPosition();
                        float scale = JImagePanControl.this.getScale();
                        viewPos.x = (int)((float)viewPos.x + (float)dx * scale);
                        viewPos.y = (int)((float)viewPos.y + (float)dy * scale);
                        JZoomControlPanel.this.scrollPane.setViewPosition(viewPos);
                        this.plantPoint = e.getPoint();
                    }
                }

                @Override
                public void mouseWheelMoved(MouseWheelEvent sourceWheelEvent) {
                    JZoomControlPanel.this.zoomSlider.setValueIsAdjusting(true);
                    JZoomControlPanel.this.zoomSlider.setValue(JZoomControlPanel.this.zoomSlider.getValue() - sourceWheelEvent.getWheelRotation());
                    JZoomControlPanel.this.zoomSlider.setValueIsAdjusting(false);
                }
            };
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
            this.addMouseWheelListener(listener);
        }

        private float getScale() {
            Dimension compDim = JZoomControlPanel.this.scrollPane.getImageComponent().getImageSize();
            float widthScale = (float)compDim.width / (float)this.getWidth();
            float heightScale = (float)compDim.height / (float)this.getHeight();
            return Math.max(widthScale, heightScale);
        }

        private Rectangle getViewportBounds() {
            Rectangle viewRect = JZoomControlPanel.this.scrollPane.getViewport().getViewRect();
            Rectangle ib = JZoomControlPanel.this.scrollPane.getImageComponent().getImageBounds();
            viewRect.x -= ib.x;
            viewRect.y -= ib.y;
            return JZoomControlPanel.scaleRect(viewRect, 1.0f / this.getScale());
        }

        private Rectangle getImageBounds() {
            JImageComponent imageComp = JZoomControlPanel.this.scrollPane.getImageComponent();
            Dimension img = imageComp.getImageSize();
            Dimension bounds = GraphicsUtilities.fitWithinBounds(img.width, img.height, this.getSize());
            int ix = Math.round((float)Math.max(this.getWidth() - bounds.width, 0) / 2.0f);
            int iy = Math.round((float)Math.max(this.getHeight() - bounds.height, 0) / 2.0f);
            return new Rectangle(ix, iy, bounds.width, bounds.height);
        }

        @Override
        protected void paintComponent(Graphics g2d) {
            super.paintComponent(g2d);
            Graphics2D g = (Graphics2D)g2d.create();
            if (this.cachedThumb == null) {
                this.createCachedThumb();
            }
            g.drawImage((Image)this.cachedThumb, 0, 0, null);
            Rectangle ib = this.getImageBounds();
            BufferedImage mask = this.getGraphicsConfiguration().createCompatibleImage(ib.width, ib.height, 3);
            Graphics2D maskg = mask.createGraphics();
            maskg.setColor(new Color(127, 127, 127, 127));
            maskg.fillRect(0, 0, ib.width, ib.height);
            maskg.setComposite(AlphaComposite.Clear);
            Rectangle vr = this.getViewportBounds();
            maskg.fillRect(vr.x, vr.y, vr.width, vr.height);
            g.drawImage((Image)mask, ib.x, ib.y, null);
            g.setColor(new Color(255, 255, 255, 192));
            g.drawRect(ib.x + vr.x, ib.y + vr.y, vr.width, vr.height);
            g.dispose();
        }

        private void createCachedThumb() {
            this.cachedThumb = this.getGraphicsConfiguration().createCompatibleImage(this.getWidth(), this.getHeight(), 3);
            Graphics2D g = this.cachedThumb.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            JImageComponent imageComp = JZoomControlPanel.this.scrollPane.getImageComponent();
            Image img = imageComp.getImage();
            Rectangle ib = this.getImageBounds();
            g.drawImage(img, ib.x, ib.y, ib.width, ib.height, null);
            g.dispose();
        }
    }
}

