/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import se.datadosen.jalbum.JAlbumColor;

public class JVUMeter
extends JComponent {
    private static final int PREF_WIDTH = 140;
    private static final int PREF_HEIGHT = 16;
    private static final int SEGMENT_WIDTH = 4;
    private static final int SEGMENT_SPACING = 2;
    private static final int TOTAL_SEGMENT_WIDTH = 6;
    private static final float RED_ZONE = 0.75f;
    private int maxValue = Short.MAX_VALUE;
    private int value;

    public JVUMeter(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        this.repaint();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        int oldValue = this.value;
        this.value = value;
        if (value != oldValue) {
            this.repaint();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(140, 16);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(140, 16);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintSegments(g, this.maxValue, 50);
        this.paintSegments(g, this.value, 255);
    }

    private void paintSegments(Graphics g, int value, int alpha) {
        int i;
        Insets in = this.getInsets();
        int w = this.getWidth() - in.left - in.right;
        int h = this.getHeight() - in.top - in.bottom;
        int totalSegments = w / 6;
        int firstRedSegment = (int)((float)totalSegments * 0.75f);
        int segRange = this.maxValue / totalSegments;
        int currentSegments = totalSegments * (value + segRange / 2) / this.maxValue;
        g.setColor(this.getPaintingColor(new Color(0, 255, 0, alpha)));
        for (i = 0; i < currentSegments && i < firstRedSegment; ++i) {
            g.fillRect(in.left + i * 6, in.top, 4, h);
        }
        g.setColor(this.getPaintingColor(new Color(255, 0, 0, alpha)));
        for (i = firstRedSegment; i < currentSegments; ++i) {
            g.fillRect(in.left + i * 6, in.top, 4, h);
        }
    }

    private Color getPaintingColor(Color c) {
        if (this.isEnabled()) {
            return c;
        }
        return new Color(JAlbumColor.grayLevel(c), JAlbumColor.grayLevel(c), JAlbumColor.grayLevel(c), c.getAlpha());
    }
}

