/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import net.jalbum.component.JPopupPanel;
import net.miginfocom.swing.MigLayout;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.JPlainToggleButton;
import se.datadosen.component.RiverLayout2;
import se.datadosen.jalbum.DataRate;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.Platform;
import se.datadosen.util.StringUtil;

public class JProgressManager
extends JPanel {
    static final int TASKS_PANEL_VOFFSET = -16;
    Action abortAllAction = new LambdaAction(Msg.get("ui.abortAll"), () -> this.abortAllTasks());
    private LinkedList<TaskStatus> tasks = new LinkedList();
    private JTasksPanel tasksPanel = new JTasksPanel();
    private TaskStatus mainTask;
    private JPanel mainPanel = new JPanel(new RiverLayout2(0, 2));
    private JLabel messageLabel = new JSmallLabel();
    private JProgressBar progressBar = new JProgressBar();
    private JPlainToggleButton pauseButton = JProgressManager.createPauseButton();
    private JButton abortButton = JProgressManager.createAbortButton();
    private JLabel moreLabel = new JSmallLabel();
    private JComponent referenceComponent = this;
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!JProgressManager.this.tasksPanel.isShowing()) {
                JProgressManager.this.showTasksPanel();
            } else {
                JProgressManager.this.tasksPanel.transferFocus();
            }
        }
    };
    PropertyChangeListener propertyChangeListener = pce -> this.updateMainUI();
    ChangeListener changeListener = ce -> this.updateMainUI();

    public JProgressManager(JFrame frame) {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setLayout(new BorderLayout());
        this.mainPanel.add(this.messageLabel);
        this.mainPanel.add(Box.createHorizontalStrut(6));
        this.mainPanel.add(this.progressBar);
        this.mainPanel.add(this.pauseButton);
        this.mainPanel.add(this.abortButton);
        this.mainPanel.add(Box.createHorizontalStrut(4));
        this.mainPanel.add(this.moreLabel);
        this.moreLabel.setVisible(false);
        this.mainPanel.addMouseListener(this.mouseListener);
        this.mainPanel.setToolTipText(Msg.get("ui.clickForDetails"));
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.abortAllAction);
        this.mainPanel.setComponentPopupMenu(popup);
        this.add(this.mainPanel);
        this.mainPanel.setVisible(false);
    }

    private void abortAllTasks() {
        ArrayList<TaskStatus> tmpList = new ArrayList<TaskStatus>(this.tasks);
        for (int i = tmpList.size() - 1; i >= 0; --i) {
            TaskStatus ts = (TaskStatus)tmpList.get(i);
            if (ts.onAbort != null) {
                ts.onAbort.run();
                continue;
            }
            this.removeTask(ts);
        }
    }

    public boolean isShowingTasksPanel() {
        return this.tasksPanel.isVisible();
    }

    public void showTasksPanel() {
        this.tasksPanel.layoutPanel();
        Dimension ps = this.tasksPanel.getPreferredSize();
        this.tasksPanel.setSize(ps);
        this.tasksPanel.show(this.referenceComponent, 0, -16);
        this.tasksPanel.validate();
    }

    public void hideTasksPanel() {
        this.tasksPanel.setVisible(false);
    }

    public void setMainTask(TaskStatus ts) {
        SwingUtilities.invokeLater(() -> {
            if (this.mainTask != null) {
                this.mainTask.messageLabel.setFont(this.mainTask.messageLabel.getFont().deriveFont(0));
                this.mainTask.messageLabel.removePropertyChangeListener(this.propertyChangeListener);
                this.mainTask.subMessageLabel.removePropertyChangeListener(this.propertyChangeListener);
                this.mainTask.progressBar.removePropertyChangeListener(this.propertyChangeListener);
                this.mainTask.progressBar.removeChangeListener(this.changeListener);
            }
            this.mainTask = ts;
            if (this.mainTask != null) {
                this.mainTask.messageLabel.setFont(this.mainTask.messageLabel.getFont().deriveFont(1));
                this.mainTask.messageLabel.addPropertyChangeListener(this.propertyChangeListener);
                this.mainTask.subMessageLabel.addPropertyChangeListener(this.propertyChangeListener);
                this.mainTask.progressBar.addPropertyChangeListener(this.propertyChangeListener);
                this.mainTask.progressBar.addChangeListener(this.changeListener);
                this.progressBar.setModel(this.mainTask.progressBar.getModel());
                this.pauseButton.setModel(this.mainTask.pauseButton.getModel());
                this.abortButton.setModel(this.mainTask.abortButton.getModel());
            }
            if (this.tasksPanel.isVisible()) {
                this.layoutTasksPanel();
            }
            this.updateMainUI();
            this.mainPanel.setVisible(this.mainTask != null);
        });
    }

    public TaskStatus getMainTask() {
        return this.mainTask;
    }

    public JComponent getReferenceComponent() {
        return this.referenceComponent;
    }

    public void setReferenceComponent(JComponent referenceComponent) {
        this.referenceComponent = referenceComponent;
    }

    private void updateMoreLabel() {
        this.moreLabel.setText("(" + Msg.get("ui.nMore", this.tasks.size() - 1) + "...)");
        this.moreLabel.setVisible(this.tasks.size() > 1);
    }

    private void updateMainUI() {
        if (this.mainTask != null) {
            this.messageLabel.setText(this.mainTask.messageLabel.getText());
            this.progressBar.setStringPainted(this.mainTask.progressBar.isStringPainted());
            this.progressBar.setString(this.mainTask.barText);
            this.progressBar.setIndeterminate(this.mainTask.progressBar.isIndeterminate());
            this.pauseButton.setVisible(this.mainTask.pauseButton.isVisible());
            this.abortButton.setVisible(this.mainTask.abortButton.isVisible());
        } else {
            this.mainPanel.setVisible(false);
        }
    }

    private void layoutTasksPanel() {
        this.tasksPanel.layoutPanel();
    }

    public void addTask(TaskStatus ts) {
        JAlbumUtilities.runOnAWT(() -> {
            if (!this.tasks.contains(ts)) {
                this.tasks.addLast(ts);
                this.updateMoreLabel();
                if (this.tasksPanel.isShowing()) {
                    this.tasksPanel.addTaskToPanel(ts);
                    this.tasksPanel.setSize(this.tasksPanel.getPreferredSize());
                    this.tasksPanel.adjustLocation(this.referenceComponent, 0, -16);
                    this.tasksPanel.repaint();
                }
            }
        });
    }

    public void removeTask(TaskStatus oldTask) {
        SwingUtilities.invokeLater(() -> {
            oldTask.aborted = true;
            this.tasks.remove(oldTask);
            if (this.tasks.isEmpty()) {
                this.tasksPanel.setVisible(false);
            }
            this.updateMoreLabel();
            if (this.tasksPanel.isVisible()) {
                this.layoutTasksPanel();
            }
            if (oldTask == this.mainTask) {
                TaskStatus next = null;
                for (TaskStatus ts : this.tasks) {
                    if (!ts.isStarted()) continue;
                    next = ts;
                    break;
                }
                if (next == null && !this.tasks.isEmpty()) {
                    next = this.tasks.get(0);
                }
                this.setMainTask(next);
            }
        });
    }

    public void startTask(TaskStatus ts) {
        ts.start();
        if (this.mainTask == null) {
            this.setMainTask(ts);
        }
    }

    @Override
    public Dimension getMaximumSize() {
        return super.getPreferredSize();
    }

    private static JPlainToggleButton createPauseButton() {
        JPlainToggleButton pauseButton = new JPlainToggleButton(Icons.smaller("pause"), Icons.smaller("pause-1"));
        pauseButton.setSelectedIcon(Icons.smaller("play"));
        pauseButton.setRolloverSelectedIcon(Icons.smaller("play-1"));
        pauseButton.setToolTipText(Msg.get("progress.pause"));
        pauseButton.setSelectedToolTipText(Msg.get("ui.continue"));
        return pauseButton;
    }

    private static JButton createAbortButton() {
        JPlainButton abortButton = new JPlainButton(Icons.smaller("abort"), Icons.smaller("abort-1"));
        abortButton.setToolTipText(Msg.get("abort"));
        return abortButton;
    }

    private class JTasksPanel
    extends JPopupPanel {
        private JPanel content = new JPanel();
        private JScrollPane scroller = new JScrollPane(this.content, 20, 31){

            @Override
            public Dimension getPreferredSize() {
                Dimension ps = super.getPreferredSize();
                Window win = SwingUtilities.getWindowAncestor(this);
                if (win != null) {
                    return new Dimension(ps.width + this.getVerticalScrollBar().getWidth() / 2, Math.min(ps.height, 3 * win.getHeight() / 4));
                }
                return ps;
            }
        };

        JTasksPanel() {
            MouseAdapter adapter = new MouseAdapter(){};
            this.addMouseListener(adapter);
            this.addMouseMotionListener(adapter);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    SwingUtilities.invokeLater(() -> JTasksPanel.this.uninstall());
                }
            });
            this.setBorder(BorderFactory.createLineBorder(JAlbumColor.controlShadow));
            this.scroller.setBorder(null);
            this.scroller.getVerticalScrollBar().setUnitIncrement(16);
            this.setLayout(new BorderLayout());
            this.content.setLayout((LayoutManager)new MigLayout("insets 8"));
            this.add(this.scroller);
            JPopupMenu popup = new JPopupMenu();
            popup.add(JProgressManager.this.abortAllAction);
            this.content.setComponentPopupMenu(popup);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addTaskToPanel(TaskStatus ts) {
            Object object = this.content.getTreeLock();
            synchronized (object) {
                if (this.content.getComponentCount() > 0) {
                    this.content.add((Component)JAlbumBorders.createSeparator(), "growx, span 2, wrap 0");
                }
                this.content.add(ts.messageLabel);
                this.content.add((Component)ts.progressBar, "split 3");
                this.content.add((Component)ts.pauseButton, "gapafter 0");
                this.content.add((Component)ts.abortButton, "gapbefore 0, wrap");
                this.content.add((Component)ts.subMessageLabel, "growx, span 2, split 2");
                this.content.add((Component)ts.timeLeftLabel, "wrap 0");
                ts.timeLeftLabel.setToolTipText(Msg.get("progress.estimatedTimeLeftInfo").replaceAll(":", ""));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void layoutPanel() {
            Object object = this.content.getTreeLock();
            synchronized (object) {
                this.content.removeAll();
                for (TaskStatus ts : JProgressManager.this.tasks) {
                    this.addTaskToPanel(ts);
                }
            }
            this.setSize(this.getPreferredSize());
            this.adjustLocation(JProgressManager.this.referenceComponent, 0, -16);
            this.repaint();
        }

        @Override
        public void doLayout() {
            super.doLayout();
        }
    }

    private static class JSmallLabel
    extends JLabel {
        public JSmallLabel() {
            this.init();
        }

        public JSmallLabel(String text) {
            super(text);
            this.init();
        }

        private void init() {
            int amount = Platform.isMac() ? 2 : 1;
            this.setFont(this.getFont().deriveFont(this.getFont().getSize2D() - (float)amount));
        }

        private void makeBold() {
            this.setFont(this.getFont().deriveFont(1));
        }
    }

    public static class TaskStatus {
        private Runnable onPause;
        private Runnable onAbort;
        private boolean started;
        private boolean aborted;
        private JLabel messageLabel = new JLabel();
        private JLabel subMessageLabel = new JSmallLabel(" ");
        private JLabel timeLeftLabel = new JSmallLabel();
        private JProgressBar progressBar = new JProgressBar();
        private String barText;
        private String barExtraText;
        private JPlainToggleButton pauseButton = JProgressManager.createPauseButton();
        private JButton abortButton = JProgressManager.createAbortButton();
        private DataRate timeLeftEstimator = new DataRate(10);

        public TaskStatus() {
            this.init();
        }

        public TaskStatus(String message) {
            this.init();
            this.setMessage(message);
        }

        public void setMessage(String message) {
            JAlbumUtilities.runOnAWT(() -> this.messageLabel.setText(message));
        }

        public void setSubMessage(String subMessage) {
            JAlbumUtilities.runOnAWT(() -> this.subMessageLabel.setText(StringUtil.limit(subMessage, 65)));
        }

        public void setIndeterminate(boolean indeterminate) {
            JAlbumUtilities.runOnAWT(() -> this.progressBar.setIndeterminate(indeterminate));
        }

        public void setStringPainted(boolean painted) {
            JAlbumUtilities.runOnAWT(() -> this.progressBar.setStringPainted(painted));
        }

        private void start() {
            Runnable r = () -> {
                this.started = true;
                this.progressBar.setEnabled(true);
                this.pauseButton.setEnabled(true);
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(r);
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        public boolean isStarted() {
            return this.started;
        }

        public boolean isPaused() {
            return this.pauseButton.isSelected();
        }

        public void abort() {
            this.aborted = true;
            this.pauseButton.setSelected(false);
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public void onPause(Runnable t) {
            this.onPause = t;
            this.pauseButton.addActionListener(ae -> this.onPause.run());
            this.pauseButton.setVisible(true);
        }

        public void onAbort(Runnable t) {
            this.onAbort = t;
            this.abortButton.addActionListener(ae -> this.onAbort.run());
            this.abortButton.setVisible(true);
        }

        public void setProgress(String text) {
            this.barText = text;
            this.barExtraText = null;
            JAlbumUtilities.runOnAWT(() -> this.progressBar.setString(text));
        }

        public void setProgress(String text, int value, int maximum) {
            this.setProgress(text, null, value, maximum);
        }

        public void setProgress(String text, String extraText, int value, int maximum) {
            String message = extraText != null ? text + extraText : text;
            this.barText = text;
            this.barExtraText = extraText;
            JAlbumUtilities.runOnAWT(() -> {
                this.progressBar.setString(message);
                this.progressBar.setMaximum(maximum);
                this.progressBar.setValue(value);
            });
        }

        private void init() {
            this.pauseButton.setVisible(false);
            this.abortButton.setVisible(this.onAbort != null);
            this.progressBar.setEnabled(false);
            this.pauseButton.setEnabled(false);
            this.progressBar.setStringPainted(true);
            Dimension ps = this.progressBar.getPreferredSize();
            this.progressBar.setPreferredSize(new Dimension((int)((double)ps.width * 2.6), ps.height));
            this.progressBar.addChangeListener(ce -> {
                int value = this.progressBar.getValue();
                this.timeLeftEstimator.update(value);
                this.timeLeftLabel.setText(this.timeLeftEstimator.estTimeLeft(this.progressBar.getMaximum() - value));
            });
        }
    }
}

