/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JPopupPanel
extends JPanel {
    private ComponentListener listener;

    public void uninstall() {
        JLayeredPane pane = (JLayeredPane)this.getParent();
        if (pane != null) {
            pane.removeComponentListener(this.listener);
            pane.remove(this);
            this.listener = null;
            pane.validate();
            pane.repaint();
        }
    }

    public void install(Component invoker) {
        Window win = SwingUtilities.windowForComponent(invoker);
        if (!(win instanceof JFrame)) {
            throw new RuntimeException("Invoker must be instance of JFrame");
        }
        JFrame frame = (JFrame)win;
        JLayeredPane pane = frame.getLayeredPane();
        pane.remove(this);
        this.setVisible(true);
        pane.add((Component)this, JLayeredPane.PALETTE_LAYER);
    }

    public void show(final Component invoker, final int x, final int y) {
        Window win = SwingUtilities.windowForComponent(invoker);
        if (!(win instanceof JFrame)) {
            throw new RuntimeException("Invoker must be instance of JFrame");
        }
        JFrame frame = (JFrame)win;
        this.adjustLocation(invoker, x, y);
        if (!this.isShowing()) {
            if (this.listener != null) {
                frame.getLayeredPane().removeComponentListener(this.listener);
            }
            JLayeredPane pane = frame.getLayeredPane();
            pane.remove(this);
            this.setVisible(true);
            pane.add((Component)this, JLayeredPane.PALETTE_LAYER);
            Dimension ps = this.getPreferredSize();
            this.setSize(ps);
            this.adjustLocation(invoker, x, y);
            this.listener = new ComponentAdapter(this){
                final /* synthetic */ JPopupPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingUtilities.invokeLater(() -> this.this$0.adjustLocation(invoker, x, y));
                }
            };
            frame.getLayeredPane().addComponentListener(this.listener);
            this.requestFocusInWindow();
        }
    }

    public void adjustLocation(Component rel, int x, int y) {
        JFrame frame = (JFrame)SwingUtilities.windowForComponent(rel);
        if (frame != null) {
            Point newLocation = SwingUtilities.convertPoint(rel, x, y, frame.getLayeredPane());
            this.setLocation(newLocation.x - this.getWidth(), newLocation.y - this.getHeight());
        }
    }
}

