/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.plaf.ListUI;
import net.jalbum.component.DraggableListCellRenderer;
import net.jalbum.component.DraggableListDropHandler;
import net.jalbum.component.JStaticList;
import net.jalbum.component.MyDragListener;
import se.datadosen.util.Item;
import se.datadosen.util.NameValue;
import se.datadosen.util.PersistentList;

public class JDraggableList<E>
extends JList<E>
implements PersistentList {
    public static final DataFlavor listItemsFlavor = new DataFlavor(ListItems.class, "List items");
    boolean useBorders;
    private JDraggableList otherList;
    private boolean primary = true;
    private boolean small;
    private ListUI myUI;

    public JDraggableList(DefaultListModel<E> dataModel) {
        super(dataModel);
        this.init();
    }

    public JDraggableList(E[] listData) {
        super(new DefaultListModel());
        DefaultListModel model = (DefaultListModel)this.getModel();
        for (E element : listData) {
            model.addElement(element);
        }
        this.init();
    }

    public boolean contains(E item) {
        return ((DefaultListModel)this.getModel()).contains(item);
    }

    public JDraggableList(E[] listData, String[] primaryItemKeys) {
        this(listData, primaryItemKeys, false);
    }

    public JDraggableList(E[] listData, E ... primaryItemKeys) {
        this(listData);
        try {
            this.createSecondaryList();
            this.setContent(primaryItemKeys);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }

    public JDraggableList(E[] listData, boolean allowDuplicates) {
        this(listData, new String[0], false);
    }

    public JDraggableList(E[] listData, String[] primaryItemKeys, boolean allowDuplicates) {
        this(listData);
        try {
            if (allowDuplicates) {
                JStaticList<E> secList = new JStaticList<E>(listData);
                this.setSecondaryList(secList);
            } else {
                this.createSecondaryList();
            }
            this.setContent(Arrays.asList(primaryItemKeys));
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }

    @Override
    public void setModel(ListModel<E> model) {
        super.setModel(model);
        this.calcVisibleRowCount();
    }

    private void calcVisibleRowCount() {
        if (this.getLayoutOrientation() == 2) {
            return;
        }
        int rows = this.getModel().getSize();
        if (this.otherList != null) {
            rows += this.otherList.getModel().getSize();
        }
        if (rows > 8) {
            rows = 8;
        }
        this.setVisibleRowCount(rows);
    }

    private JDraggableList createSecondaryList() {
        if (this.otherList != null) {
            throw new IllegalStateException("This list already has a companion list");
        }
        JDraggableList<E> secondary = new JDraggableList<E>();
        this.setSecondaryList(secondary);
        return secondary;
    }

    public JDraggableList getSecondaryList() {
        if (this.otherList == null) {
            this.createSecondaryList();
        }
        return this.otherList;
    }

    public void setSecondaryList(JDraggableList secondaryList) {
        this.primary = true;
        this.otherList = secondaryList;
        secondaryList.otherList = this;
        secondaryList.primary = false;
        this.calcVisibleRowCount();
        secondaryList.calcVisibleRowCount();
    }

    public JDraggableList() {
        this(new Object[0]);
    }

    public void includeItem(Object item, boolean include) {
        DefaultListModel model = (DefaultListModel)this.getModel();
        if (!model.contains(item) && include) {
            model.addElement(item);
        } else if (!include) {
            model.removeElement(item);
        }
    }

    @Override
    public List<String> getContent() {
        DefaultListModel model = (DefaultListModel)this.getModel();
        ArrayList<String> content = new ArrayList<String>();
        for (int i = 0; i < model.size(); ++i) {
            String val;
            Object item = model.getElementAt(i);
            if (item instanceof Item) {
                val = ((Item)item).value.toString();
            } else if (item instanceof NameValue) {
                val = ((NameValue)item).value.toString();
            } else if (item instanceof Component) {
                val = ((Component)item).getName();
                if (val == null) {
                    System.err.println("Using unnamed component in JDraggableList");
                }
            } else {
                val = item instanceof Enum ? ((Enum)item).name() : item.toString();
            }
            if (val == null) continue;
            content.add(val);
        }
        return content;
    }

    public void setContent(E ... data) {
        ArrayList<String> keys = new ArrayList<String>();
        for (E key : data) {
            if (!(key instanceof Enum)) {
                throw new IllegalArgumentException("Only Enums allowed for primaryItemKeys");
            }
            keys.add(((Enum)key).name());
        }
        this.setContent((List<String>)keys);
    }

    @Override
    public void setContent(List<String> data) {
        if (!this.primary) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.getModel();
        Object[] items = model.toArray();
        if (this.otherList != null) {
            Object[] otherItems = ((DefaultListModel)this.otherList.getModel()).toArray();
            Object[] allItems = new Object[items.length + otherItems.length];
            System.arraycopy(items, 0, allItems, 0, items.length);
            System.arraycopy(otherItems, 0, allItems, items.length, otherItems.length);
            items = allItems;
        }
        model.clear();
        ArrayList<Object> newItems = new ArrayList<Object>();
        block2: for (String key : data) {
            for (int i = 0; i < items.length; ++i) {
                String test;
                if (items[i] == null || !key.equals(test = items[i] instanceof Component ? ((Component)items[i]).getName() : (items[i] instanceof Item ? ((Item)items[i]).value.toString() : (items[i] instanceof NameValue ? ((NameValue)items[i]).value.toString() : (items[i] instanceof Enum ? ((Enum)items[i]).name() : items[i].toString()))))) continue;
                newItems.add(items[i]);
                if (this.otherList instanceof JStaticList) continue block2;
                items[i] = null;
                continue block2;
            }
        }
        model.addAll(newItems);
        if (!(this.otherList instanceof JStaticList)) {
            DefaultListModel targetModel = model;
            if (this.otherList != null) {
                targetModel = (DefaultListModel)this.otherList.getModel();
                targetModel.clear();
            }
            try {
                targetModel.addAll(Arrays.asList(items).stream().filter(item -> item != null).collect(Collectors.toList()));
            }
            catch (NoSuchMethodError e) {
                for (Object item2 : items) {
                    if (item2 == null) continue;
                    targetModel.addElement(item2);
                }
            }
        }
    }

    public JDraggableList horizontal() {
        this.setLayoutOrientation(2);
        this.setPrototypeCellValue(null);
        this.setVisibleRowCount(1);
        return this;
    }

    public JDraggableList small() {
        Font f = this.getFont();
        float newSize = Math.max(f.getSize2D() - 3.0f, 9.0f);
        this.small = true;
        this.setFont(f.deriveFont(newSize));
        if (this.otherList != null) {
            this.otherList.small = true;
            this.otherList.setFont(this.getFont());
        }
        return this;
    }

    public boolean isSmall() {
        return this.small;
    }

    public boolean isUseBorders() {
        return this.useBorders;
    }

    public JDraggableList setUseBorders(boolean useBorders) {
        this.useBorders = useBorders;
        return this;
    }

    private Dimension getOriginalPreferredScrollableViewportSize() {
        return super.getPreferredScrollableViewportSize();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.otherList != null) {
            if (this.getModel().getSize() == 0) {
                return this.otherList.getOriginalPreferredScrollableViewportSize();
            }
            if (this.otherList.getModel().getSize() == 0) {
                return this.getOriginalPreferredScrollableViewportSize();
            }
        }
        Dimension dim = super.getPreferredScrollableViewportSize();
        if (this.otherList != null) {
            Dimension otherDim = this.otherList.getOriginalPreferredScrollableViewportSize();
            return new Dimension(Math.max(dim.width, otherDim.width), Math.max(dim.height, otherDim.height));
        }
        return dim;
    }

    private void init() {
        this.calcVisibleRowCount();
        this.setSelectionMode(2);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        this.setTransferHandler(new DraggableListDropHandler(this));
        new MyDragListener(this);
        this.setCellRenderer(new DraggableListCellRenderer());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getKeyCode() == 127 || e.getKeyCode() == 8) && JDraggableList.this.primary && JDraggableList.this.otherList != null) {
                    DefaultListModel otherModel = (DefaultListModel)JDraggableList.this.otherList.getModel();
                    DefaultListModel model = (DefaultListModel)JDraggableList.this.getModel();
                    for (Object item : JDraggableList.this.getSelectedValuesList()) {
                        model.removeElement(item);
                        if (JDraggableList.this.otherList instanceof JStaticList) continue;
                        otherModel.addElement(item);
                    }
                }
            }
        });
    }

    private static class ListItems {
        private ListItems() {
        }
    }
}

