/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JCardPanel
extends JPanel {
    public static final String SELECTED_CARD_PROPERTY = "selectedCard";
    private static final String CARD_KEY = "cardKey";
    private final CardLayout cardLayout = (CardLayout)this.getLayout();
    private JComponent selectedCard;

    public JCardPanel() {
        super(new CardLayout());
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        String cardKey = constraints instanceof String ? (String)constraints : String.valueOf(System.identityHashCode(comp));
        ((JComponent)comp).putClientProperty(CARD_KEY, cardKey);
        super.addImpl(comp, cardKey, index);
        if (this.getComponentCount() == 1) {
            this.setSelectedCard((JComponent)comp);
        }
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        if (this.selectedCard == comp) {
            this.selectedCard = null;
        }
    }

    public JComponent getSelectedCard() {
        return this.selectedCard;
    }

    public void setSelectedCard(JComponent card) {
        String cardKey = (String)card.getClientProperty(CARD_KEY);
        if (cardKey == null) {
            throw new IllegalArgumentException("Component not added earlier");
        }
        JComponent oldCard = this.selectedCard;
        this.cardLayout.show(this, cardKey);
        this.selectedCard = card;
        this.firePropertyChange(SELECTED_CARD_PROPERTY, oldCard, card);
    }
}

