/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.swing.Icon;
import javax.swing.JLabel;

public class JBindableLabel
extends JLabel {
    protected final StringProperty textProperty = new SimpleStringProperty();
    protected final StringProperty toolTipTextProperty = new SimpleStringProperty();
    protected final BooleanProperty visibleProperty = new SimpleBooleanProperty(true);
    protected final BooleanProperty enabledProperty = new SimpleBooleanProperty(true);
    protected final ObjectProperty<Icon> iconProperty = new SimpleObjectProperty();

    public JBindableLabel(String text) {
        super(text);
        this.init();
    }

    public JBindableLabel(Icon image) {
        super(image);
        this.init();
    }

    public JBindableLabel() {
        this.init();
    }

    public StringProperty getTextProperty() {
        return this.textProperty;
    }

    public StringProperty getToolTipTextProperty() {
        return this.toolTipTextProperty;
    }

    public BooleanProperty getVisibleProperty() {
        return this.visibleProperty;
    }

    public BooleanProperty getEnabledProperty() {
        return this.enabledProperty;
    }

    public ObjectProperty<Icon> getIconProperty() {
        return this.iconProperty;
    }

    private void init() {
        this.textProperty.addListener(ce -> super.setText(this.textProperty.getValueSafe()));
        this.toolTipTextProperty.addListener(ce -> super.setToolTipText(this.toolTipTextProperty.getValueSafe()));
        this.visibleProperty.addListener(ce -> super.setVisible(this.visibleProperty.getValue()));
        this.enabledProperty.addListener(ce -> super.setEnabled(this.enabledProperty.getValue()));
        this.iconProperty.addListener(ce -> super.setIcon((Icon)this.iconProperty.getValue()));
    }

    @Override
    public void setText(String text) {
        this.assertNotBound((Property)this.textProperty);
        super.setText(text);
    }

    @Override
    public void setIcon(Icon icon) {
        this.assertNotBound((Property)this.iconProperty);
        super.setIcon(icon);
    }

    @Override
    public void setToolTipText(String text) {
        this.assertNotBound((Property)this.toolTipTextProperty);
        super.setToolTipText(text);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.assertNotBound((Property)this.enabledProperty);
        super.setEnabled(enabled);
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.assertNotBound((Property)this.visibleProperty);
        super.setVisible(aFlag);
    }

    private void assertNotBound(Property prop) {
        if (prop != null && prop.isBound()) {
            throw new IllegalStateException("Property " + prop.getName() + " is bound");
        }
    }
}

