/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.TransferHandler;
import net.jalbum.component.JDraggableList;
import net.jalbum.component.MyDragListener;

class DraggableListDropHandler<E>
extends TransferHandler {
    JList<E> list;

    public DraggableListDropHandler(JList<E> list) {
        this.list = list;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDataFlavorSupported(JDraggableList.listItemsFlavor)) {
            return false;
        }
        JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
        return dl.getIndex() != -1;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        try {
            if (!this.canImport(support)) {
                return false;
            }
            JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
            int targetIndex = dl.getIndex();
            try {
                DefaultListModel model = (DefaultListModel)this.list.getModel();
                List items = (List)support.getTransferable().getTransferData(JDraggableList.listItemsFlavor);
                int i = targetIndex;
                DefaultListModel sourceModel = MyDragListener.currentSource != null ? (DefaultListModel)MyDragListener.currentSource.getModel() : null;
                for (Object item : items) {
                    int existingIndex;
                    if (support.getDropAction() == 2 && sourceModel != null && (existingIndex = sourceModel.indexOf(item)) != -1) {
                        sourceModel.removeElementAt(existingIndex);
                        if (sourceModel == model && existingIndex < targetIndex) {
                            --targetIndex;
                        }
                    }
                    int n = --i;
                    ++i;
                    model.add(n, item);
                }
                this.list.getSelectionModel().setSelectionInterval(targetIndex, i - 1);
                this.list.requestFocusInWindow();
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Logger.getLogger(DraggableListDropHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            return true;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            return false;
        }
    }
}

