/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.component;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import net.jalbum.component.DraggableBorder;
import net.jalbum.component.JDraggableList;

class DraggableListCellRenderer
extends JLabel
implements ListCellRenderer<Object> {
    private boolean isSelected;

    DraggableListCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Object> theList, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JList<? extends Object> list = theList;
        this.setIcon(null);
        if (value instanceof JLabel) {
            this.setText(((JLabel)value).getText());
            this.setIcon(((JLabel)value).getIcon());
        } else {
            this.setText(value.toString());
        }
        this.setFont(list.getFont());
        this.isSelected = isSelected;
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        RoundRectBorder faintRectangle = RoundRectBorder.INSTANCE;
        Border padding = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        boolean small = list instanceof JDraggableList && ((JDraggableList)list).isSmall();
        DraggableBorder knob = DraggableBorder.getInstance(list.getLayoutOrientation() == 2, small);
        if (((JDraggableList)list).useBorders) {
            this.setBorder(BorderFactory.createCompoundBorder(padding, BorderFactory.createCompoundBorder(faintRectangle, knob)));
        } else {
            this.setBorder(knob);
        }
        return this;
    }

    private static class RoundRectBorder
    implements Border {
        public static final RoundRectBorder INSTANCE = new RoundRectBorder();
        private Insets borderInsets = new Insets(0, 0, 0, 0);

        private RoundRectBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g2d, int x, int y, int width, int height) {
            Graphics2D g = (Graphics2D)g2d;
            DraggableListCellRenderer renderer = (DraggableListCellRenderer)c;
            if (!renderer.isSelected) {
                g.setColor(UIManager.getColor("textInactiveText"));
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawRoundRect(x, y, width, height, 6, 6);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.borderInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

