/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.browser;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.dom.Document;
import com.teamdev.jxbrowser.dom.event.Event;
import com.teamdev.jxbrowser.dom.event.EventType;
import com.teamdev.jxbrowser.dom.event.MouseEvent;
import com.teamdev.jxbrowser.engine.Engine;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.PasswordStore;
import com.teamdev.jxbrowser.engine.ProprietaryFeature;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.fullscreen.FullScreen;
import com.teamdev.jxbrowser.fullscreen.event.FullScreenEntered;
import com.teamdev.jxbrowser.fullscreen.event.FullScreenExited;
import com.teamdev.jxbrowser.logging.Level;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.navigation.event.FrameLoadFailed;
import com.teamdev.jxbrowser.navigation.event.LoadFinished;
import com.teamdev.jxbrowser.navigation.event.LoadStarted;
import com.teamdev.jxbrowser.navigation.event.NavigationFinished;
import com.teamdev.jxbrowser.navigation.event.NavigationStarted;
import com.teamdev.jxbrowser.net.HttpHeader;
import com.teamdev.jxbrowser.net.HttpStatus;
import com.teamdev.jxbrowser.net.Scheme;
import com.teamdev.jxbrowser.net.UrlRequestJob;
import com.teamdev.jxbrowser.net.callback.InterceptUrlRequestCallback;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.scene.web.WebErrorEvent;
import javafx.scene.web.WebEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.jalbum.browser.WebBrowser;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;

public class JxBrowser
implements WebBrowser {
    private final Browser browser;
    private BrowserView browserView;
    private final ObjectProperty<Worker.State> stateProperty = new SimpleObjectProperty((Object)Worker.State.READY);
    private final StringProperty locationProperty = new SimpleStringProperty();
    private final StringProperty titleProperty = new SimpleStringProperty();
    private final BooleanProperty canGoBackProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty canGoForwardProperty = new SimpleBooleanProperty(false);
    private static Engine engine;
    private Container container;
    private Consumer<java.awt.Point> rightClickListener;
    private static java.util.logging.Logger logger;
    final KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
    final KeyStroke f11 = KeyStroke.getKeyStroke(122, 0);
    private Action exitFullScreenAction = new AbstractAction("Exit Full Screen"){

        @Override
        public void actionPerformed(ActionEvent e) {
            JxBrowser.this.doSetFullScreen(false);
        }
    };
    private JFrame fullscreenFrame = new FullScreenFrame();
    private final Observer<Event> listener = ce -> {
        Component focusOwner;
        if (((MouseEvent)ce).button() == MouseEvent.Button.MAIN && ((focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null || focusOwner.getParent() != this.getView())) {
            this.getView().requestFocusInWindow();
        }
        if (this.rightClickListener != null && ce instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)ce;
            if (((MouseEvent)ce).button() == MouseEvent.Button.RIGHT) {
                SwingUtilities.invokeLater(() -> {
                    Point pos = mouseEvent.clientLocation();
                    this.rightClickListener.accept(new java.awt.Point(pos.x(), pos.y()));
                });
            }
        }
    };

    public JxBrowser() {
        this.preinit();
        JxBrowser.initEngine();
        this.browser = engine.newBrowser();
        this.init();
    }

    public JxBrowser(Browser browser) {
        this.preinit();
        this.browser = browser;
        this.init();
    }

    public BrowserView getView() {
        if (this.browserView == null) {
            this.browserView = BrowserView.newInstance((Browser)this.browser);
        }
        return this.browserView;
    }

    @Override
    public synchronized void load(String url) {
        this.browser.navigation().loadUrl(url);
    }

    @Override
    public synchronized void reload() {
        this.browser.navigation().reload();
    }

    @Override
    public synchronized void reloadIgnoringCache() {
        this.browser.navigation().reloadIgnoringCache();
    }

    @Override
    public synchronized void waitUntilLoaded() throws InterruptedException {
        if (this.browser.navigation().isLoading()) {
            CountDownLatch latch = new CountDownLatch(1);
            Subscription sub = this.browser.navigation().on(LoadFinished.class, event -> latch.countDown());
            if (this.browser.navigation().isLoading()) {
                latch.await();
            }
            sub.unsubscribe();
        }
    }

    @Override
    public void stop() {
        this.browser.navigation().stop();
    }

    @Override
    public String getLocation() {
        return this.browser.url();
    }

    @Override
    public ReadOnlyStringProperty locationProperty() {
        return this.locationProperty;
    }

    @Override
    public String getTitle() {
        return this.browser.title();
    }

    @Override
    public ReadOnlyStringProperty titleProperty() {
        return this.titleProperty;
    }

    @Override
    public ReadOnlyObjectProperty<Worker.State> stateProperty() {
        return this.stateProperty;
    }

    @Override
    public void goBack() {
        this.browser.navigation().goBack();
    }

    @Override
    public ReadOnlyBooleanProperty canGoBackProperty() {
        return this.canGoBackProperty;
    }

    @Override
    public void goForward() {
        this.browser.navigation().goForward();
    }

    @Override
    public ReadOnlyBooleanProperty canGoForwardProperty() {
        return this.canGoForwardProperty;
    }

    @Override
    public void dispose() {
    }

    private void init() {
        this.browser.navigation().on(LoadFinished.class, event -> this.browser.mainFrame().ifPresent(f -> f.document().ifPresent(d -> d.documentElement().ifPresent(element -> {
            element.removeEventListener(EventType.MOUSE_DOWN, this.listener, false);
            element.addEventListener(EventType.MOUSE_DOWN, this.listener, false);
        }))));
        this.browser.navigation().on(LoadStarted.class, event -> this.stateProperty.set((Object)Worker.State.RUNNING));
        this.browser.navigation().on(LoadFinished.class, event -> this.stateProperty.set((Object)Worker.State.SUCCEEDED));
        this.browser.navigation().on(FrameLoadFailed.class, event -> this.stateProperty.set((Object)Worker.State.FAILED));
        this.browser.navigation().on(NavigationStarted.class, event -> {
            this.canGoBackProperty.set(event.navigation().canGoBack());
            this.canGoForwardProperty.set(event.navigation().canGoForward());
        });
        this.browser.navigation().on(NavigationFinished.class, event -> {
            this.canGoBackProperty.set(event.navigation().canGoBack());
            this.canGoForwardProperty.set(event.navigation().canGoForward());
            this.locationProperty.set((Object)this.browser.url());
        });
        this.browser.on(TitleChanged.class, event -> this.titleProperty.set((Object)event.title()));
        FullScreen fullScreen = this.browser.fullScreen();
        fullScreen.on(FullScreenEntered.class, event -> SwingUtilities.invokeLater(() -> this.doSetFullScreen(true)));
        fullScreen.on(FullScreenExited.class, event -> SwingUtilities.invokeLater(() -> {
            fullScreen.exit();
            this.doSetFullScreen(false);
        }));
        if (logger.isLoggable(java.util.logging.Level.FINEST)) {
            this.browser.devTools().show();
        }
        this.fullscreenFrame.setExtendedState(6);
    }

    private void preinit() {
        JxBrowser.setLoggingLevel(logger.getLevel());
    }

    @Override
    public org.w3c.dom.Document getDocument() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean elementIDExists(String id) {
        return ((Document)((Frame)this.browser.mainFrame().get()).document().get()).findElementById(id).isPresent();
    }

    @Override
    public <T> T executeScript(String command) {
        Optional frame = this.browser.mainFrame();
        if (frame.isPresent()) {
            return (T)((Frame)frame.get()).executeJavaScript(command);
        }
        throw new IllegalStateException("No page loaded to execute JavaScript");
    }

    @Override
    public void onPageLoaded(Runnable r) {
        this.stateProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue == Worker.State.SUCCEEDED) {
                r.run();
            }
        });
    }

    @Override
    public void loadContent(String content) {
        this.browser.mainFrame().ifPresent(f -> f.loadHtml(content));
    }

    private static void setLoggingLevel(java.util.logging.Level level) {
        if (level.intValue() <= java.util.logging.Level.FINER.intValue()) {
            Logger.level((Level)Level.ALL);
        } else {
            Logger.level((Level)Level.ERROR);
        }
    }

    public static synchronized void initEngine() {
        if (engine == null) {
            EngineOptions options = EngineOptions.newBuilder((RenderingMode)RenderingMode.HARDWARE_ACCELERATED).licenseKey("4UNGTNAE2CYJR19K7ESSAPXYT25MI49MPS3CKW1SCRX1MTES52NMX374N2FZDMB3AJHUDJXS6B3U0GT1N0K3CGH8TO754A1WZAKLMYCCAEXPDKJLS3UJ9GNLP8GNNENUTZT36B8Z9EY8HFZSL3N").allowFileAccessFromFiles().passwordStore(PasswordStore.BASIC).addSwitch("--disable-features=NotificationService").addSwitch("--disable-features=NativeNotifications").enableProprietaryFeature(ProprietaryFeature.AAC).enableProprietaryFeature(ProprietaryFeature.H_264).enableProprietaryFeature(ProprietaryFeature.HEVC).addScheme(Scheme.JAR, params -> {
                UrlRequestJob.Options opts = UrlRequestJob.Options.newBuilder((HttpStatus)HttpStatus.OK).addHttpHeader(HttpHeader.of((String)"Content-Type", (String)"text/html")).build();
                UrlRequestJob job = params.newUrlRequestJob(opts);
                try {
                    String u = params.urlRequest().url();
                    u = u.replaceAll("jar://file", "jar:file:");
                    URI uri = new URI(u);
                    String content = IO.readTextUrl(uri.toURL());
                    job.write(content.getBytes());
                    job.complete();
                    return InterceptUrlRequestCallback.Response.intercept((UrlRequestJob)job);
                }
                catch (IOException | URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
            }).build();
            engine = Engine.newInstance((EngineOptions)options);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> engine.close(), "JxBrowser shutdown hook"));
        }
    }

    @Override
    public void setOnAlert(EventHandler<WebEvent<String>> eventHandler) {
    }

    @Override
    public void setOnError(EventHandler<WebErrorEvent> eventHandler) {
        this.browser.navigation().on(FrameLoadFailed.class, event -> eventHandler.handle((javafx.event.Event)new WebErrorEvent((Object)this, WebErrorEvent.ANY, event.toString(), null)));
    }

    @Override
    public void openDeveloperTools() {
        this.browser.devTools().show();
    }

    @Override
    public void viewSource() {
        ((Frame)this.browser.mainFrame().get()).viewSource();
    }

    @Override
    public void onRightClick(Consumer<java.awt.Point> listener) {
        this.rightClickListener = listener;
    }

    @Override
    public boolean isFullScreen() {
        return this.fullscreenFrame.isVisible();
    }

    private void requestFullScreen() {
        this.browser.mainFrame().ifPresent(frame -> frame.executeJavaScript("document.documentElement.requestFullscreen();"));
    }

    @Override
    public void setFullScreen(boolean fullScreen) {
        if (fullScreen && !this.isFullScreen()) {
            this.requestFullScreen();
        } else if (this.isFullScreen()) {
            this.browser.fullScreen().exit();
        }
    }

    private void doSetFullScreen(boolean fullScreen) {
        if (fullScreen && !this.isFullScreen()) {
            this.container = this.getView().getParent();
            this.container.remove((Component)this.getView());
            if (Platform.isLinux() || this.fullscreenFrame.getGraphicsConfiguration() != this.container.getGraphicsConfiguration()) {
                this.fullscreenFrame.dispose();
                this.fullscreenFrame = new FullScreenFrame(this.container.getGraphicsConfiguration());
            }
            this.fullscreenFrame.getContentPane().add((Component)this.getView());
            this.fullscreenFrame.setExtendedState(6);
            this.fullscreenFrame.validate();
            this.fullscreenFrame.setVisible(true);
        } else if (this.isFullScreen() && this.fullscreenFrame != null) {
            this.fullscreenFrame.getContentPane().remove((Component)this.getView());
            this.fullscreenFrame.setVisible(false);
            this.container.add((Component)this.getView());
            this.container.validate();
            this.getView().requestFocusInWindow();
        }
    }

    static {
        logger = java.util.logging.Logger.getLogger("jalbum");
    }

    private static class FullScreenFrame
    extends JFrame {
        public FullScreenFrame() throws HeadlessException {
            this.setUndecorated(true);
        }

        public FullScreenFrame(GraphicsConfiguration gc) {
            super(gc);
            this.setUndecorated(true);
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible && (Platform.isMac() || Platform.isLinux())) {
                this.getGraphicsConfiguration().getDevice().setFullScreenWindow(this);
            } else {
                this.getGraphicsConfiguration().getDevice().setFullScreenWindow(null);
            }
            super.setVisible(visible);
        }
    }
}

