/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.browser;

import java.awt.image.BufferedImage;
import java.io.File;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javax.swing.Icon;
import se.datadosen.jalbum.Icons;

public class BrowserWindow
extends Stage {
    Button back = new Button();
    Button forward = new Button();
    TextField address = new TextField();
    ProgressIndicator progress = new ProgressIndicator();
    WebView browser;
    WebEngine engine;
    WebHistory history;

    private void go() {
        if (this.address.getText().indexOf(58) == -1) {
            this.address.setText("http://" + this.address.getText());
        }
        this.engine.load(this.address.getText());
    }

    public BrowserWindow() {
        BorderPane mainPane = new BorderPane();
        this.back.setGraphic((Node)new ImageView((Image)BrowserWindow.toImage(Icons.small("previous"))));
        this.forward.setGraphic((Node)new ImageView((Image)BrowserWindow.toImage(Icons.small("next"))));
        this.browser = new WebView();
        this.engine = this.browser.getEngine();
        this.history = this.engine.getHistory();
        this.titleProperty().bind((ObservableValue)this.engine.titleProperty());
        this.engine.setOnError(event -> System.err.println(event));
        this.back.setOnAction(e -> this.history.go(-1));
        this.forward.setOnAction(e -> this.history.go(1));
        this.back.disableProperty().bind((ObservableValue)Bindings.equal((int)0, (ObservableNumberValue)this.history.currentIndexProperty()));
        this.forward.disableProperty().bind((ObservableValue)this.history.currentIndexProperty().add(1).greaterThanOrEqualTo((ObservableNumberValue)Bindings.size((ObservableList)this.history.getEntries())));
        HBox.setHgrow((Node)this.address, (Priority)Priority.ALWAYS);
        this.address.setPromptText("Enter web address here");
        this.address.setOnAction(e -> this.go());
        this.engine.locationProperty().addListener(ce -> {
            if (!this.address.getText().equals(this.engine.getLocation())) {
                this.address.setText(this.engine.getLocation());
            }
        });
        this.history.currentIndexProperty().addListener(cl -> {
            String url = ((WebHistory.Entry)this.history.getEntries().get(this.history.getCurrentIndex())).getUrl();
            if (!this.address.getText().equals(url)) {
                this.address.setText(url);
            }
        });
        Worker loadWorker = this.engine.getLoadWorker();
        this.progress.setPrefSize(24.0, 24.0);
        this.progress.visibleProperty().bind((ObservableValue)loadWorker.runningProperty());
        Button reloadButton = new Button();
        reloadButton.setGraphic((Node)new ImageView((Image)BrowserWindow.toImage(Icons.small("refresh"))));
        reloadButton.setOnAction(ae -> this.engine.reload());
        ToolBar toolbar = new ToolBar(new Node[]{this.back, this.forward, this.address, this.progress, reloadButton});
        toolbar.setOnDragOver(event -> {
            event.acceptTransferModes(TransferMode.ANY);
            event.consume();
        });
        toolbar.setOnDragDropped(event -> {
            if (event.getDragboard().hasFiles()) {
                File f = (File)event.getDragboard().getFiles().get(0);
                this.address.setText(f.toURI().toString());
                this.go();
            }
            event.setDropCompleted(true);
            event.consume();
        });
        mainPane.setTop((Node)toolbar);
        mainPane.setCenter((Node)this.browser);
        this.addEventHandler(KeyEvent.KEY_PRESSED, ev -> {
            switch (ev.getCode()) {
                case W: {
                    if (ev.isShortcutDown()) {
                        this.getScene().getWindow().hide();
                        break;
                    }
                }
                case F4: {
                    if (!ev.isAltDown()) break;
                    this.getScene().getWindow().hide();
                }
            }
            ev.consume();
        });
        Scene root = new Scene((Parent)mainPane, 1000.0, 800.0);
        this.setScene(root);
        this.centerOnScreen();
    }

    public WebEngine getEngine() {
        return this.engine;
    }

    private static WritableImage toImage(Icon icon) {
        BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(null, bi.getGraphics(), 0, 0);
        return SwingFXUtils.toFXImage((BufferedImage)bi, null);
    }
}

