/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.jalbum.browser.BrowserToolBar;
import net.jalbum.browser.WebBrowser;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.AliasAction;

public class BrowserPane
extends JPanel {
    private final WebBrowser browser;
    private final BrowserToolBar toolBar;
    private final JComponent container;
    private final JComponent browserContainer;

    public BrowserPane(WebBrowser browser) {
        this.browser = browser;
        browser.stateProperty().addListener((observable, oldValue, newValue) -> {
            switch (newValue) {
                case RUNNING: {
                    this.updateIconStates(browser.getLocation());
                    break;
                }
                case SUCCEEDED: 
                case CANCELLED: 
                case FAILED: {
                    this.firePropertyChange("PageTitleChanged", null, browser.getTitle());
                    this.firePropertyChange("URLChanged", null, browser.getLocation());
                }
            }
        });
        this.browserContainer = browser.getView();
        this.toolBar = this.createToolBar(browser);
        this.container = new JPanel(new BorderLayout());
        this.container.add((Component)this.browserContainer, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "North");
        this.container.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, JAlbumColor.border));
        this.add((Component)this.container, "Center");
        browser.onRightClick(p -> {
            JPopupMenu menu = new JPopupMenu();
            menu.add(this.toolBar.backwardAction);
            menu.add(this.toolBar.forwardAction);
            menu.add(this.toolBar.reloadAction);
            menu.add(this.toolBar.stopAction);
            menu.addSeparator();
            menu.add(new AliasAction(this.toolBar.phonePreviewerAction, Msg.get("ui.phonePreviewer")));
            menu.addSeparator();
            menu.add(this.toolBar.viewSourceAction);
            menu.add(this.toolBar.developerToolsAction);
            menu.show(this.browserContainer, p.x, p.y);
        });
    }

    private BrowserToolBar createToolBar(WebBrowser browser) {
        BrowserToolBar toolBar = new BrowserToolBar(browser);
        toolBar.addPropertyChangeListener("TabClosed", evt -> this.firePropertyChange("TabClosed", false, true));
        return toolBar;
    }

    public void dispose() {
        this.browser.dispose();
    }

    private void updateIconStates(String string) {
        this.toolBar.updateIconStates(string, this.browser);
    }

    public WebBrowser getBrowser() {
        return this.browser;
    }

    public synchronized void reload() {
        this.reload(false);
    }

    public synchronized void reload(boolean ignoreCache) {
        if (ignoreCache) {
            this.browser.reloadIgnoringCache();
        } else {
            this.browser.reload();
        }
        this.waitUntilLoaded();
    }

    public synchronized void waitUntilLoaded() {
        try {
            this.browser.waitUntilLoaded();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(BrowserPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public synchronized void load(String url) {
        this.browser.load(url);
        this.waitUntilLoaded();
    }
}

