/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum;

import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsonable;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.awt.Dimension;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.jalbum.OutputFormat;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.GraphicsUtilities;
import se.datadosen.util.IO;

public class Variant
implements Serializable,
Comparable,
Jsonable {
    public static final Variant TYPICAL = new Variant(1.0f, null);
    private float scale;
    private OutputFormat format;

    public Variant(float scale, OutputFormat format) {
        this.setScale(scale);
        this.setFormat(format);
    }

    public float getScale() {
        return this.scale;
    }

    public final void setScale(float scale) {
        if ((double)scale < 0.25 || scale > 4.0f) {
            throw new IllegalArgumentException(Msg.get("ui.invalidScale", Float.valueOf(scale), 0.25, 4));
        }
        this.scale = scale;
    }

    public OutputFormat getFormat() {
        return this.format;
    }

    public final void setFormat(OutputFormat format) {
        this.format = format;
    }

    public Dimension getScaledDimension(Dimension dim) {
        return new Dimension((int)((float)dim.width * this.scale), (int)((float)dim.height * this.scale));
    }

    public String getFilename(AlbumObject ao, Dimension typicalDim) throws IOException {
        String baseName = IO.baseName(ao.getFile());
        Dimension origSize = ao.getSize();
        Dimension scaledSize = GraphicsUtilities.fitWithinBounds(origSize.width, origSize.height, this.getScaledDimension(typicalDim));
        return baseName + "-" + scaledSize.width + "w." + this.format.getExtension();
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Float.floatToIntBits(this.scale);
        hash = 67 * hash + Objects.hashCode((Object)this.format);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Variant other = (Variant)obj;
        if (this.scale != other.scale) {
            return false;
        }
        return this.format == other.format;
    }

    public int compareTo(Object o) {
        Variant other = (Variant)o;
        return (int)(1000.0f * other.scale - 1000.0f * this.scale);
    }

    public String toString() {
        return "Variant{scale=" + this.scale + ", format=" + String.valueOf((Object)this.format) + "}";
    }

    public String toJson() {
        return "{\"scale\":" + this.scale + ",\"format\":\"" + this.format.name() + "\"}";
    }

    public void toJson(Writer writable) throws IOException {
        writable.write(this.toJson());
    }

    public static List<Variant> deserialize(String json) {
        ArrayList<Variant> list = new ArrayList<Variant>();
        JsonArray jsonArray = Jsoner.deserialize((String)json, (JsonArray)new JsonArray());
        for (Object o : jsonArray) {
            JsonObject jo = (JsonObject)o;
            list.add(new Variant(jo.getFloat(Jsoner.mintJsonKey((String)"scale", (Object)Float.valueOf(1.0f))).floatValue(), OutputFormat.valueOf(jo.getString(Jsoner.mintJsonKey((String)"format", (Object)"JPEG")))));
        }
        return list;
    }
}

